package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourcePolicy(
    resourceArn: Optional[String] = Optional.Absent,
    policy: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ResourcePolicy = {
    import ResourcePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ResourcePolicy
      .builder()
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ResourcePolicy.ReadOnly =
    zio.aws.redshift.model.ResourcePolicy.wrap(buildAwsValue())
}
object ResourcePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ResourcePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ResourcePolicy =
      zio.aws.redshift.model.ResourcePolicy(
        resourceArn.map(value => value),
        policy.map(value => value)
      )
    def resourceArn: Optional[String]
    def policy: Optional[String]
    def getResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ResourcePolicy
  ) extends zio.aws.redshift.model.ResourcePolicy.ReadOnly {
    override val resourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => value: String)
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ResourcePolicy
  ): zio.aws.redshift.model.ResourcePolicy.ReadOnly = new Wrapper(impl)
}
