package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IntegrationError(
    errorCode: String,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.IntegrationError = {
    import IntegrationError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.IntegrationError
      .builder()
      .errorCode(errorCode: java.lang.String)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.IntegrationError.ReadOnly =
    zio.aws.redshift.model.IntegrationError.wrap(buildAwsValue())
}
object IntegrationError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.IntegrationError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.IntegrationError =
      zio.aws.redshift.model
        .IntegrationError(errorCode, errorMessage.map(value => value))
    def errorCode: String
    def errorMessage: Optional[String]
    def getErrorCode: ZIO[Any, Nothing, String] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.IntegrationError
  ) extends zio.aws.redshift.model.IntegrationError.ReadOnly {
    override val errorCode: String = impl.errorCode(): String
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.IntegrationError
  ): zio.aws.redshift.model.IntegrationError.ReadOnly = new Wrapper(impl)
}
