package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetClusterCredentialsRequest(
    dbUser: String,
    dbName: Optional[String] = Optional.Absent,
    clusterIdentifier: Optional[String] = Optional.Absent,
    durationSeconds: Optional[IntegerOptional] = Optional.Absent,
    autoCreate: Optional[BooleanOptional] = Optional.Absent,
    dbGroups: Optional[Iterable[String]] = Optional.Absent,
    customDomainName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest = {
    import GetClusterCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
      .builder()
      .dbUser(dbUser: java.lang.String)
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(durationSeconds.map(value => value: Integer))(
        _.durationSeconds
      )
      .optionallyWith(autoCreate.map(value => value: java.lang.Boolean))(
        _.autoCreate
      )
      .optionallyWith(
        dbGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbGroups)
      .optionallyWith(customDomainName.map(value => value: java.lang.String))(
        _.customDomainName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.GetClusterCredentialsRequest.ReadOnly =
    zio.aws.redshift.model.GetClusterCredentialsRequest.wrap(buildAwsValue())
}
object GetClusterCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.GetClusterCredentialsRequest =
      zio.aws.redshift.model.GetClusterCredentialsRequest(
        dbUser,
        dbName.map(value => value),
        clusterIdentifier.map(value => value),
        durationSeconds.map(value => value),
        autoCreate.map(value => value),
        dbGroups.map(value => value),
        customDomainName.map(value => value)
      )
    def dbUser: String
    def dbName: Optional[String]
    def clusterIdentifier: Optional[String]
    def durationSeconds: Optional[IntegerOptional]
    def autoCreate: Optional[BooleanOptional]
    def dbGroups: Optional[List[String]]
    def customDomainName: Optional[String]
    def getDbUser: ZIO[Any, Nothing, String] = ZIO.succeed(dbUser)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getDurationSeconds: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getAutoCreate: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("autoCreate", autoCreate)
    def getDbGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dbGroups", dbGroups)
    def getCustomDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
  ) extends zio.aws.redshift.model.GetClusterCredentialsRequest.ReadOnly {
    override val dbUser: String = impl.dbUser(): String
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val durationSeconds: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value => value: IntegerOptional)
    override val autoCreate: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.autoCreate())
      .map(value => value: BooleanOptional)
    override val dbGroups: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.dbGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val customDomainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest
  ): zio.aws.redshift.model.GetClusterCredentialsRequest.ReadOnly = new Wrapper(
    impl
  )
}
