package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeInboundIntegrationsRequest(
    integrationArn: Optional[String] = Optional.Absent,
    targetArn: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsRequest = {
    import DescribeInboundIntegrationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsRequest
      .builder()
      .optionallyWith(integrationArn.map(value => value: java.lang.String))(
        _.integrationArn
      )
      .optionallyWith(targetArn.map(value => value: java.lang.String))(
        _.targetArn
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeInboundIntegrationsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeInboundIntegrationsRequest
      .wrap(buildAwsValue())
}
object DescribeInboundIntegrationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeInboundIntegrationsRequest =
      zio.aws.redshift.model.DescribeInboundIntegrationsRequest(
        integrationArn.map(value => value),
        targetArn.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def integrationArn: Optional[String]
    def targetArn: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getIntegrationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("integrationArn", integrationArn)
    def getTargetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsRequest
  ) extends zio.aws.redshift.model.DescribeInboundIntegrationsRequest.ReadOnly {
    override val integrationArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.integrationArn())
      .map(value => value: String)
    override val targetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsRequest
  ): zio.aws.redshift.model.DescribeInboundIntegrationsRequest.ReadOnly =
    new Wrapper(impl)
}
