package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class InboundIntegration(
    integrationArn: Optional[String] = Optional.Absent,
    sourceArn: Optional[String] = Optional.Absent,
    targetArn: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.redshift.model.ZeroETLIntegrationStatus] =
      Optional.Absent,
    errors: Optional[Iterable[zio.aws.redshift.model.IntegrationError]] =
      Optional.Absent,
    createTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.InboundIntegration = {
    import InboundIntegration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.InboundIntegration
      .builder()
      .optionallyWith(integrationArn.map(value => value: java.lang.String))(
        _.integrationArn
      )
      .optionallyWith(sourceArn.map(value => value: java.lang.String))(
        _.sourceArn
      )
      .optionallyWith(targetArn.map(value => value: java.lang.String))(
        _.targetArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(createTime.map(value => TStamp.unwrap(value): Instant))(
        _.createTime
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.InboundIntegration.ReadOnly =
    zio.aws.redshift.model.InboundIntegration.wrap(buildAwsValue())
}
object InboundIntegration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.InboundIntegration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.InboundIntegration =
      zio.aws.redshift.model.InboundIntegration(
        integrationArn.map(value => value),
        sourceArn.map(value => value),
        targetArn.map(value => value),
        status.map(value => value),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createTime.map(value => value)
      )
    def integrationArn: Optional[String]
    def sourceArn: Optional[String]
    def targetArn: Optional[String]
    def status: Optional[zio.aws.redshift.model.ZeroETLIntegrationStatus]
    def errors: Optional[List[zio.aws.redshift.model.IntegrationError.ReadOnly]]
    def createTime: Optional[TStamp]
    def getIntegrationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("integrationArn", integrationArn)
    def getSourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getTargetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.ZeroETLIntegrationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.IntegrationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createTime", createTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.InboundIntegration
  ) extends zio.aws.redshift.model.InboundIntegration.ReadOnly {
    override val integrationArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.integrationArn())
      .map(value => value: String)
    override val sourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => value: String)
    override val targetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.redshift.model.ZeroETLIntegrationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.redshift.model.ZeroETLIntegrationStatus.wrap(value)
        )
    override val errors
        : Optional[List[zio.aws.redshift.model.IntegrationError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.IntegrationError.wrap(item)
          }.toList
        )
    override val createTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.InboundIntegration
  ): zio.aws.redshift.model.InboundIntegration.ReadOnly = new Wrapper(impl)
}
