package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{IntegerOptional, Integer, TStamp}
import scala.jdk.CollectionConverters.*
final case class Snapshot(
    snapshotIdentifier: Optional[String] = Optional.Absent,
    clusterIdentifier: Optional[String] = Optional.Absent,
    snapshotCreateTime: Optional[TStamp] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    clusterCreateTime: Optional[TStamp] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    clusterVersion: Optional[String] = Optional.Absent,
    engineFullVersion: Optional[String] = Optional.Absent,
    snapshotType: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    numberOfNodes: Optional[Integer] = Optional.Absent,
    dbName: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    encryptedWithHSM: Optional[Boolean] = Optional.Absent,
    accountsWithRestoreAccess: Optional[
      Iterable[zio.aws.redshift.model.AccountWithRestoreAccess]
    ] = Optional.Absent,
    ownerAccount: Optional[String] = Optional.Absent,
    totalBackupSizeInMegaBytes: Optional[Double] = Optional.Absent,
    actualIncrementalBackupSizeInMegaBytes: Optional[Double] = Optional.Absent,
    backupProgressInMegaBytes: Optional[Double] = Optional.Absent,
    currentBackupRateInMegaBytesPerSecond: Optional[Double] = Optional.Absent,
    estimatedSecondsToCompletion: Optional[Long] = Optional.Absent,
    elapsedTimeInSeconds: Optional[Long] = Optional.Absent,
    sourceRegion: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent,
    restorableNodeTypes: Optional[Iterable[String]] = Optional.Absent,
    enhancedVpcRouting: Optional[Boolean] = Optional.Absent,
    maintenanceTrackName: Optional[String] = Optional.Absent,
    manualSnapshotRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    manualSnapshotRemainingDays: Optional[IntegerOptional] = Optional.Absent,
    snapshotRetentionStartTime: Optional[TStamp] = Optional.Absent,
    masterPasswordSecretArn: Optional[String] = Optional.Absent,
    masterPasswordSecretKmsKeyId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.Snapshot
      .builder()
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(
        snapshotCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotCreateTime)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(engineFullVersion.map(value => value: java.lang.String))(
        _.engineFullVersion
      )
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(numberOfNodes.map(value => value: java.lang.Integer))(
        _.numberOfNodes
      )
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(encryptedWithHSM.map(value => value: java.lang.Boolean))(
        _.encryptedWithHSM
      )
      .optionallyWith(
        accountsWithRestoreAccess.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountsWithRestoreAccess)
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(
        totalBackupSizeInMegaBytes.map(value => value: java.lang.Double)
      )(_.totalBackupSizeInMegaBytes)
      .optionallyWith(
        actualIncrementalBackupSizeInMegaBytes.map(value =>
          value: java.lang.Double
        )
      )(_.actualIncrementalBackupSizeInMegaBytes)
      .optionallyWith(
        backupProgressInMegaBytes.map(value => value: java.lang.Double)
      )(_.backupProgressInMegaBytes)
      .optionallyWith(
        currentBackupRateInMegaBytesPerSecond.map(value =>
          value: java.lang.Double
        )
      )(_.currentBackupRateInMegaBytesPerSecond)
      .optionallyWith(
        estimatedSecondsToCompletion.map(value => value: java.lang.Long)
      )(_.estimatedSecondsToCompletion)
      .optionallyWith(elapsedTimeInSeconds.map(value => value: java.lang.Long))(
        _.elapsedTimeInSeconds
      )
      .optionallyWith(sourceRegion.map(value => value: java.lang.String))(
        _.sourceRegion
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        restorableNodeTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.restorableNodeTypes)
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(
        manualSnapshotRemainingDays.map(value => value: java.lang.Integer)
      )(_.manualSnapshotRemainingDays)
      .optionallyWith(
        snapshotRetentionStartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotRetentionStartTime)
      .optionallyWith(
        masterPasswordSecretArn.map(value => value: java.lang.String)
      )(_.masterPasswordSecretArn)
      .optionallyWith(
        masterPasswordSecretKmsKeyId.map(value => value: java.lang.String)
      )(_.masterPasswordSecretKmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.Snapshot.ReadOnly =
    zio.aws.redshift.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.redshift.model.Snapshot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.Snapshot =
      zio.aws.redshift.model.Snapshot(
        snapshotIdentifier.map(value => value),
        clusterIdentifier.map(value => value),
        snapshotCreateTime.map(value => value),
        status.map(value => value),
        port.map(value => value),
        availabilityZone.map(value => value),
        clusterCreateTime.map(value => value),
        masterUsername.map(value => value),
        clusterVersion.map(value => value),
        engineFullVersion.map(value => value),
        snapshotType.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        dbName.map(value => value),
        vpcId.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        encryptedWithHSM.map(value => value),
        accountsWithRestoreAccess.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerAccount.map(value => value),
        totalBackupSizeInMegaBytes.map(value => value),
        actualIncrementalBackupSizeInMegaBytes.map(value => value),
        backupProgressInMegaBytes.map(value => value),
        currentBackupRateInMegaBytesPerSecond.map(value => value),
        estimatedSecondsToCompletion.map(value => value),
        elapsedTimeInSeconds.map(value => value),
        sourceRegion.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        restorableNodeTypes.map(value => value),
        enhancedVpcRouting.map(value => value),
        maintenanceTrackName.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        manualSnapshotRemainingDays.map(value => value),
        snapshotRetentionStartTime.map(value => value),
        masterPasswordSecretArn.map(value => value),
        masterPasswordSecretKmsKeyId.map(value => value)
      )
    def snapshotIdentifier: Optional[String]
    def clusterIdentifier: Optional[String]
    def snapshotCreateTime: Optional[TStamp]
    def status: Optional[String]
    def port: Optional[Integer]
    def availabilityZone: Optional[String]
    def clusterCreateTime: Optional[TStamp]
    def masterUsername: Optional[String]
    def clusterVersion: Optional[String]
    def engineFullVersion: Optional[String]
    def snapshotType: Optional[String]
    def nodeType: Optional[String]
    def numberOfNodes: Optional[Integer]
    def dbName: Optional[String]
    def vpcId: Optional[String]
    def encrypted: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def encryptedWithHSM: Optional[Boolean]
    def accountsWithRestoreAccess: Optional[
      List[zio.aws.redshift.model.AccountWithRestoreAccess.ReadOnly]
    ]
    def ownerAccount: Optional[String]
    def totalBackupSizeInMegaBytes: Optional[Double]
    def actualIncrementalBackupSizeInMegaBytes: Optional[Double]
    def backupProgressInMegaBytes: Optional[Double]
    def currentBackupRateInMegaBytesPerSecond: Optional[Double]
    def estimatedSecondsToCompletion: Optional[Long]
    def elapsedTimeInSeconds: Optional[Long]
    def sourceRegion: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def restorableNodeTypes: Optional[List[String]]
    def enhancedVpcRouting: Optional[Boolean]
    def maintenanceTrackName: Optional[String]
    def manualSnapshotRetentionPeriod: Optional[IntegerOptional]
    def manualSnapshotRemainingDays: Optional[IntegerOptional]
    def snapshotRetentionStartTime: Optional[TStamp]
    def masterPasswordSecretArn: Optional[String]
    def masterPasswordSecretKmsKeyId: Optional[String]
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getSnapshotCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getEngineFullVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineFullVersion", engineFullVersion)
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEncryptedWithHSM: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encryptedWithHSM", encryptedWithHSM)
    def getAccountsWithRestoreAccess: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.AccountWithRestoreAccess.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "accountsWithRestoreAccess",
      accountsWithRestoreAccess
    )
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getTotalBackupSizeInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "totalBackupSizeInMegaBytes",
        totalBackupSizeInMegaBytes
      )
    def getActualIncrementalBackupSizeInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "actualIncrementalBackupSizeInMegaBytes",
        actualIncrementalBackupSizeInMegaBytes
      )
    def getBackupProgressInMegaBytes: ZIO[Any, AwsError, Double] = AwsError
      .unwrapOptionField("backupProgressInMegaBytes", backupProgressInMegaBytes)
    def getCurrentBackupRateInMegaBytesPerSecond: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "currentBackupRateInMegaBytesPerSecond",
        currentBackupRateInMegaBytesPerSecond
      )
    def getEstimatedSecondsToCompletion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedSecondsToCompletion",
        estimatedSecondsToCompletion
      )
    def getElapsedTimeInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("elapsedTimeInSeconds", elapsedTimeInSeconds)
    def getSourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceRegion", sourceRegion)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRestorableNodeTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("restorableNodeTypes", restorableNodeTypes)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getManualSnapshotRemainingDays: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRemainingDays",
        manualSnapshotRemainingDays
      )
    def getSnapshotRetentionStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "snapshotRetentionStartTime",
        snapshotRetentionStartTime
      )
    def getMasterPasswordSecretArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("masterPasswordSecretArn", masterPasswordSecretArn)
    def getMasterPasswordSecretKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "masterPasswordSecretKmsKeyId",
        masterPasswordSecretKmsKeyId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.Snapshot
  ) extends zio.aws.redshift.model.Snapshot.ReadOnly {
    override val snapshotIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotIdentifier())
      .map(value => value: String)
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val snapshotCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotCreateTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val clusterCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterCreateTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val clusterVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterVersion())
      .map(value => value: String)
    override val engineFullVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineFullVersion())
      .map(value => value: String)
    override val snapshotType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotType())
      .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val numberOfNodes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfNodes())
      .map(value => value: Integer)
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val encryptedWithHSM: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptedWithHSM())
      .map(value => value: Boolean)
    override val accountsWithRestoreAccess: Optional[
      List[zio.aws.redshift.model.AccountWithRestoreAccess.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountsWithRestoreAccess())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.AccountWithRestoreAccess.wrap(item)
        }.toList
      )
    override val ownerAccount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => value: String)
    override val totalBackupSizeInMegaBytes: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalBackupSizeInMegaBytes())
        .map(value => value: Double)
    override val actualIncrementalBackupSizeInMegaBytes: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualIncrementalBackupSizeInMegaBytes())
        .map(value => value: Double)
    override val backupProgressInMegaBytes: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupProgressInMegaBytes())
        .map(value => value: Double)
    override val currentBackupRateInMegaBytesPerSecond: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentBackupRateInMegaBytesPerSecond())
        .map(value => value: Double)
    override val estimatedSecondsToCompletion: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedSecondsToCompletion())
        .map(value => value: Long)
    override val elapsedTimeInSeconds: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.elapsedTimeInSeconds())
      .map(value => value: Long)
    override val sourceRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceRegion())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
    override val restorableNodeTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restorableNodeTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val enhancedVpcRouting: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enhancedVpcRouting())
      .map(value => value: Boolean)
    override val maintenanceTrackName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceTrackName())
      .map(value => value: String)
    override val manualSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val manualSnapshotRemainingDays: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRemainingDays())
        .map(value => value: IntegerOptional)
    override val snapshotRetentionStartTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionStartTime())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val masterPasswordSecretArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterPasswordSecretArn())
        .map(value => value: String)
    override val masterPasswordSecretKmsKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterPasswordSecretKmsKeyId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.Snapshot
  ): zio.aws.redshift.model.Snapshot.ReadOnly = new Wrapper(impl)
}
