package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SecondaryClusterInfo(
    availabilityZone: Optional[String] = Optional.Absent,
    clusterNodes: Optional[Iterable[zio.aws.redshift.model.ClusterNode]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.SecondaryClusterInfo = {
    import SecondaryClusterInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.SecondaryClusterInfo
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        clusterNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterNodes)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.SecondaryClusterInfo.ReadOnly =
    zio.aws.redshift.model.SecondaryClusterInfo.wrap(buildAwsValue())
}
object SecondaryClusterInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.SecondaryClusterInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.SecondaryClusterInfo =
      zio.aws.redshift.model.SecondaryClusterInfo(
        availabilityZone.map(value => value),
        clusterNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def availabilityZone: Optional[String]
    def clusterNodes
        : Optional[List[zio.aws.redshift.model.ClusterNode.ReadOnly]]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getClusterNodes: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterNode.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterNodes", clusterNodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.SecondaryClusterInfo
  ) extends zio.aws.redshift.model.SecondaryClusterInfo.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val clusterNodes
        : Optional[List[zio.aws.redshift.model.ClusterNode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterNodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ClusterNode.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.SecondaryClusterInfo
  ): zio.aws.redshift.model.SecondaryClusterInfo.ReadOnly = new Wrapper(impl)
}
