package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailoverPrimaryComputeResponse(
    cluster: Optional[zio.aws.redshift.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.FailoverPrimaryComputeResponse = {
    import FailoverPrimaryComputeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.FailoverPrimaryComputeResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.FailoverPrimaryComputeResponse.ReadOnly =
    zio.aws.redshift.model.FailoverPrimaryComputeResponse.wrap(buildAwsValue())
}
object FailoverPrimaryComputeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.FailoverPrimaryComputeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.FailoverPrimaryComputeResponse =
      zio.aws.redshift.model
        .FailoverPrimaryComputeResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.redshift.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.FailoverPrimaryComputeResponse
  ) extends zio.aws.redshift.model.FailoverPrimaryComputeResponse.ReadOnly {
    override val cluster: Optional[zio.aws.redshift.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.redshift.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.FailoverPrimaryComputeResponse
  ): zio.aws.redshift.model.FailoverPrimaryComputeResponse.ReadOnly =
    new Wrapper(impl)
}
