package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{LongOptional, TStamp}
import scala.jdk.CollectionConverters.*
final case class TableRestoreStatus(
    tableRestoreRequestId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.redshift.model.TableRestoreStatusType] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent,
    requestTime: Optional[TStamp] = Optional.Absent,
    progressInMegaBytes: Optional[LongOptional] = Optional.Absent,
    totalDataInMegaBytes: Optional[LongOptional] = Optional.Absent,
    clusterIdentifier: Optional[String] = Optional.Absent,
    snapshotIdentifier: Optional[String] = Optional.Absent,
    sourceDatabaseName: Optional[String] = Optional.Absent,
    sourceSchemaName: Optional[String] = Optional.Absent,
    sourceTableName: Optional[String] = Optional.Absent,
    targetDatabaseName: Optional[String] = Optional.Absent,
    targetSchemaName: Optional[String] = Optional.Absent,
    newTableName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.TableRestoreStatus = {
    import TableRestoreStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.TableRestoreStatus
      .builder()
      .optionallyWith(
        tableRestoreRequestId.map(value => value: java.lang.String)
      )(_.tableRestoreRequestId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(requestTime.map(value => TStamp.unwrap(value): Instant))(
        _.requestTime
      )
      .optionallyWith(progressInMegaBytes.map(value => value: java.lang.Long))(
        _.progressInMegaBytes
      )
      .optionallyWith(totalDataInMegaBytes.map(value => value: java.lang.Long))(
        _.totalDataInMegaBytes
      )
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(sourceDatabaseName.map(value => value: java.lang.String))(
        _.sourceDatabaseName
      )
      .optionallyWith(sourceSchemaName.map(value => value: java.lang.String))(
        _.sourceSchemaName
      )
      .optionallyWith(sourceTableName.map(value => value: java.lang.String))(
        _.sourceTableName
      )
      .optionallyWith(targetDatabaseName.map(value => value: java.lang.String))(
        _.targetDatabaseName
      )
      .optionallyWith(targetSchemaName.map(value => value: java.lang.String))(
        _.targetSchemaName
      )
      .optionallyWith(newTableName.map(value => value: java.lang.String))(
        _.newTableName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.TableRestoreStatus.ReadOnly =
    zio.aws.redshift.model.TableRestoreStatus.wrap(buildAwsValue())
}
object TableRestoreStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.TableRestoreStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.TableRestoreStatus =
      zio.aws.redshift.model.TableRestoreStatus(
        tableRestoreRequestId.map(value => value),
        status.map(value => value),
        message.map(value => value),
        requestTime.map(value => value),
        progressInMegaBytes.map(value => value),
        totalDataInMegaBytes.map(value => value),
        clusterIdentifier.map(value => value),
        snapshotIdentifier.map(value => value),
        sourceDatabaseName.map(value => value),
        sourceSchemaName.map(value => value),
        sourceTableName.map(value => value),
        targetDatabaseName.map(value => value),
        targetSchemaName.map(value => value),
        newTableName.map(value => value)
      )
    def tableRestoreRequestId: Optional[String]
    def status: Optional[zio.aws.redshift.model.TableRestoreStatusType]
    def message: Optional[String]
    def requestTime: Optional[TStamp]
    def progressInMegaBytes: Optional[LongOptional]
    def totalDataInMegaBytes: Optional[LongOptional]
    def clusterIdentifier: Optional[String]
    def snapshotIdentifier: Optional[String]
    def sourceDatabaseName: Optional[String]
    def sourceSchemaName: Optional[String]
    def sourceTableName: Optional[String]
    def targetDatabaseName: Optional[String]
    def targetSchemaName: Optional[String]
    def newTableName: Optional[String]
    def getTableRestoreRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableRestoreRequestId", tableRestoreRequestId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.TableRestoreStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getRequestTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("requestTime", requestTime)
    def getProgressInMegaBytes: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("progressInMegaBytes", progressInMegaBytes)
    def getTotalDataInMegaBytes: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("totalDataInMegaBytes", totalDataInMegaBytes)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getSourceDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceDatabaseName", sourceDatabaseName)
    def getSourceSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceSchemaName", sourceSchemaName)
    def getSourceTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceTableName", sourceTableName)
    def getTargetDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetDatabaseName", targetDatabaseName)
    def getTargetSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetSchemaName", targetSchemaName)
    def getNewTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newTableName", newTableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.TableRestoreStatus
  ) extends zio.aws.redshift.model.TableRestoreStatus.ReadOnly {
    override val tableRestoreRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableRestoreRequestId())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.redshift.model.TableRestoreStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.redshift.model.TableRestoreStatusType.wrap(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val requestTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.requestTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val progressInMegaBytes: Optional[LongOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressInMegaBytes())
        .map(value => value: LongOptional)
    override val totalDataInMegaBytes: Optional[LongOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalDataInMegaBytes())
        .map(value => value: LongOptional)
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val snapshotIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotIdentifier())
      .map(value => value: String)
    override val sourceDatabaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDatabaseName())
      .map(value => value: String)
    override val sourceSchemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceSchemaName())
      .map(value => value: String)
    override val sourceTableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceTableName())
      .map(value => value: String)
    override val targetDatabaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetDatabaseName())
      .map(value => value: String)
    override val targetSchemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetSchemaName())
      .map(value => value: String)
    override val newTableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.newTableName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.TableRestoreStatus
  ): zio.aws.redshift.model.TableRestoreStatus.ReadOnly = new Wrapper(impl)
}
