package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SupportedOperation(
    operationName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.SupportedOperation = {
    import SupportedOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.SupportedOperation
      .builder()
      .optionallyWith(operationName.map(value => value: java.lang.String))(
        _.operationName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.SupportedOperation.ReadOnly =
    zio.aws.redshift.model.SupportedOperation.wrap(buildAwsValue())
}
object SupportedOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.SupportedOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.SupportedOperation =
      zio.aws.redshift.model
        .SupportedOperation(operationName.map(value => value))
    def operationName: Optional[String]
    def getOperationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operationName", operationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.SupportedOperation
  ) extends zio.aws.redshift.model.SupportedOperation.ReadOnly {
    override val operationName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operationName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.SupportedOperation
  ): zio.aws.redshift.model.SupportedOperation.ReadOnly = new Wrapper(impl)
}
