package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RebootClusterRequest(clusterIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RebootClusterRequest = {
    import RebootClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RebootClusterRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RebootClusterRequest.ReadOnly =
    zio.aws.redshift.model.RebootClusterRequest.wrap(buildAwsValue())
}
object RebootClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RebootClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RebootClusterRequest =
      zio.aws.redshift.model.RebootClusterRequest(clusterIdentifier)
    def clusterIdentifier: String
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RebootClusterRequest
  ) extends zio.aws.redshift.model.RebootClusterRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RebootClusterRequest
  ): zio.aws.redshift.model.RebootClusterRequest.ReadOnly = new Wrapper(impl)
}
