package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  CustomDomainCertificateArnString,
  CustomDomainNameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyCustomDomainAssociationRequest(
    customDomainName: Optional[CustomDomainNameString] = Optional.Absent,
    customDomainCertificateArn: Optional[CustomDomainCertificateArnString] =
      Optional.Absent,
    clusterIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationRequest = {
    import ModifyCustomDomainAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationRequest
      .builder()
      .optionallyWith(
        customDomainName.map(value =>
          CustomDomainNameString.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(
        customDomainCertificateArn.map(value =>
          CustomDomainCertificateArnString.unwrap(value): java.lang.String
        )
      )(_.customDomainCertificateArn)
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyCustomDomainAssociationRequest.ReadOnly =
    zio.aws.redshift.model.ModifyCustomDomainAssociationRequest
      .wrap(buildAwsValue())
}
object ModifyCustomDomainAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.ModifyCustomDomainAssociationRequest =
      zio.aws.redshift.model.ModifyCustomDomainAssociationRequest(
        customDomainName.map(value => value),
        customDomainCertificateArn.map(value => value),
        clusterIdentifier
      )
    def customDomainName: Optional[CustomDomainNameString]
    def customDomainCertificateArn: Optional[CustomDomainCertificateArnString]
    def clusterIdentifier: String
    def getCustomDomainName: ZIO[Any, AwsError, CustomDomainNameString] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getCustomDomainCertificateArn
        : ZIO[Any, AwsError, CustomDomainCertificateArnString] =
      AwsError.unwrapOptionField(
        "customDomainCertificateArn",
        customDomainCertificateArn
      )
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationRequest
  ) extends zio.aws.redshift.model.ModifyCustomDomainAssociationRequest.ReadOnly {
    override val customDomainName: Optional[CustomDomainNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.redshift.model.primitives.CustomDomainNameString(value)
        )
    override val customDomainCertificateArn
        : Optional[CustomDomainCertificateArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainCertificateArn())
      .map(value =>
        zio.aws.redshift.model.primitives
          .CustomDomainCertificateArnString(value)
      )
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationRequest
  ): zio.aws.redshift.model.ModifyCustomDomainAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
