package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateHsmConfigurationRequest(
    hsmConfigurationIdentifier: String,
    description: String,
    hsmIpAddress: String,
    hsmPartitionName: String,
    hsmPartitionPassword: String,
    hsmServerPublicCertificate: String,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest = {
    import CreateHsmConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest
      .builder()
      .hsmConfigurationIdentifier(hsmConfigurationIdentifier: java.lang.String)
      .description(description: java.lang.String)
      .hsmIpAddress(hsmIpAddress: java.lang.String)
      .hsmPartitionName(hsmPartitionName: java.lang.String)
      .hsmPartitionPassword(hsmPartitionPassword: java.lang.String)
      .hsmServerPublicCertificate(hsmServerPublicCertificate: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateHsmConfigurationRequest.ReadOnly =
    zio.aws.redshift.model.CreateHsmConfigurationRequest.wrap(buildAwsValue())
}
object CreateHsmConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateHsmConfigurationRequest =
      zio.aws.redshift.model.CreateHsmConfigurationRequest(
        hsmConfigurationIdentifier,
        description,
        hsmIpAddress,
        hsmPartitionName,
        hsmPartitionPassword,
        hsmServerPublicCertificate,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hsmConfigurationIdentifier: String
    def description: String
    def hsmIpAddress: String
    def hsmPartitionName: String
    def hsmPartitionPassword: String
    def hsmServerPublicCertificate: String
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getHsmConfigurationIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(hsmConfigurationIdentifier)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getHsmIpAddress: ZIO[Any, Nothing, String] = ZIO.succeed(hsmIpAddress)
    def getHsmPartitionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(hsmPartitionName)
    def getHsmPartitionPassword: ZIO[Any, Nothing, String] =
      ZIO.succeed(hsmPartitionPassword)
    def getHsmServerPublicCertificate: ZIO[Any, Nothing, String] =
      ZIO.succeed(hsmServerPublicCertificate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest
  ) extends zio.aws.redshift.model.CreateHsmConfigurationRequest.ReadOnly {
    override val hsmConfigurationIdentifier: String =
      impl.hsmConfigurationIdentifier(): String
    override val description: String = impl.description(): String
    override val hsmIpAddress: String = impl.hsmIpAddress(): String
    override val hsmPartitionName: String = impl.hsmPartitionName(): String
    override val hsmPartitionPassword: String =
      impl.hsmPartitionPassword(): String
    override val hsmServerPublicCertificate: String =
      impl.hsmServerPublicCertificate(): String
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest
  ): zio.aws.redshift.model.CreateHsmConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
