package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClusterNode(
    nodeRole: Optional[String] = Optional.Absent,
    privateIPAddress: Optional[String] = Optional.Absent,
    publicIPAddress: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterNode = {
    import ClusterNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterNode
      .builder()
      .optionallyWith(nodeRole.map(value => value: java.lang.String))(
        _.nodeRole
      )
      .optionallyWith(privateIPAddress.map(value => value: java.lang.String))(
        _.privateIPAddress
      )
      .optionallyWith(publicIPAddress.map(value => value: java.lang.String))(
        _.publicIPAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterNode.ReadOnly =
    zio.aws.redshift.model.ClusterNode.wrap(buildAwsValue())
}
object ClusterNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterNode =
      zio.aws.redshift.model.ClusterNode(
        nodeRole.map(value => value),
        privateIPAddress.map(value => value),
        publicIPAddress.map(value => value)
      )
    def nodeRole: Optional[String]
    def privateIPAddress: Optional[String]
    def publicIPAddress: Optional[String]
    def getNodeRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeRole", nodeRole)
    def getPrivateIPAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIPAddress", privateIPAddress)
    def getPublicIPAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIPAddress", publicIPAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterNode
  ) extends zio.aws.redshift.model.ClusterNode.ReadOnly {
    override val nodeRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeRole())
      .map(value => value: String)
    override val privateIPAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIPAddress())
      .map(value => value: String)
    override val publicIPAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIPAddress())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterNode
  ): zio.aws.redshift.model.ClusterNode.ReadOnly = new Wrapper(impl)
}
