package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait ScheduledActionState {
  def unwrap
      : software.amazon.awssdk.services.redshift.model.ScheduledActionState
}
object ScheduledActionState {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.ScheduledActionState
  ): zio.aws.redshift.model.ScheduledActionState = value match {
    case software.amazon.awssdk.services.redshift.model.ScheduledActionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.ScheduledActionState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.redshift.model.ScheduledActionState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.ScheduledActionState {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduledActionState =
      software.amazon.awssdk.services.redshift.model.ScheduledActionState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.redshift.model.ScheduledActionState {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduledActionState =
      software.amazon.awssdk.services.redshift.model.ScheduledActionState.ACTIVE
  }
  case object DISABLED extends zio.aws.redshift.model.ScheduledActionState {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ScheduledActionState =
      software.amazon.awssdk.services.redshift.model.ScheduledActionState.DISABLED
  }
}
