package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{Integer, TStamp}
import scala.jdk.CollectionConverters.*
final case class ReservedNodeExchangeStatus(
    reservedNodeExchangeRequestId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.redshift.model.ReservedNodeExchangeStatusType] =
      Optional.Absent,
    requestTime: Optional[TStamp] = Optional.Absent,
    sourceReservedNodeId: Optional[String] = Optional.Absent,
    sourceReservedNodeType: Optional[String] = Optional.Absent,
    sourceReservedNodeCount: Optional[Integer] = Optional.Absent,
    targetReservedNodeOfferingId: Optional[String] = Optional.Absent,
    targetReservedNodeType: Optional[String] = Optional.Absent,
    targetReservedNodeCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus = {
    import ReservedNodeExchangeStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus
      .builder()
      .optionallyWith(
        reservedNodeExchangeRequestId.map(value => value: java.lang.String)
      )(_.reservedNodeExchangeRequestId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(requestTime.map(value => TStamp.unwrap(value): Instant))(
        _.requestTime
      )
      .optionallyWith(
        sourceReservedNodeId.map(value => value: java.lang.String)
      )(_.sourceReservedNodeId)
      .optionallyWith(
        sourceReservedNodeType.map(value => value: java.lang.String)
      )(_.sourceReservedNodeType)
      .optionallyWith(
        sourceReservedNodeCount.map(value => value: java.lang.Integer)
      )(_.sourceReservedNodeCount)
      .optionallyWith(
        targetReservedNodeOfferingId.map(value => value: java.lang.String)
      )(_.targetReservedNodeOfferingId)
      .optionallyWith(
        targetReservedNodeType.map(value => value: java.lang.String)
      )(_.targetReservedNodeType)
      .optionallyWith(
        targetReservedNodeCount.map(value => value: java.lang.Integer)
      )(_.targetReservedNodeCount)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly =
    zio.aws.redshift.model.ReservedNodeExchangeStatus.wrap(buildAwsValue())
}
object ReservedNodeExchangeStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ReservedNodeExchangeStatus =
      zio.aws.redshift.model.ReservedNodeExchangeStatus(
        reservedNodeExchangeRequestId.map(value => value),
        status.map(value => value),
        requestTime.map(value => value),
        sourceReservedNodeId.map(value => value),
        sourceReservedNodeType.map(value => value),
        sourceReservedNodeCount.map(value => value),
        targetReservedNodeOfferingId.map(value => value),
        targetReservedNodeType.map(value => value),
        targetReservedNodeCount.map(value => value)
      )
    def reservedNodeExchangeRequestId: Optional[String]
    def status: Optional[zio.aws.redshift.model.ReservedNodeExchangeStatusType]
    def requestTime: Optional[TStamp]
    def sourceReservedNodeId: Optional[String]
    def sourceReservedNodeType: Optional[String]
    def sourceReservedNodeCount: Optional[Integer]
    def targetReservedNodeOfferingId: Optional[String]
    def targetReservedNodeType: Optional[String]
    def targetReservedNodeCount: Optional[Integer]
    def getReservedNodeExchangeRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedNodeExchangeRequestId",
        reservedNodeExchangeRequestId
      )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ReservedNodeExchangeStatusType
    ] = AwsError.unwrapOptionField("status", status)
    def getRequestTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("requestTime", requestTime)
    def getSourceReservedNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceReservedNodeId", sourceReservedNodeId)
    def getSourceReservedNodeType: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceReservedNodeType", sourceReservedNodeType)
    def getSourceReservedNodeCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("sourceReservedNodeCount", sourceReservedNodeCount)
    def getTargetReservedNodeOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetReservedNodeOfferingId",
        targetReservedNodeOfferingId
      )
    def getTargetReservedNodeType: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("targetReservedNodeType", targetReservedNodeType)
    def getTargetReservedNodeCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("targetReservedNodeCount", targetReservedNodeCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus
  ) extends zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly {
    override val reservedNodeExchangeRequestId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodeExchangeRequestId())
        .map(value => value: String)
    override val status
        : Optional[zio.aws.redshift.model.ReservedNodeExchangeStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.redshift.model.ReservedNodeExchangeStatusType.wrap(value)
        )
    override val requestTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.requestTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val sourceReservedNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceReservedNodeId())
      .map(value => value: String)
    override val sourceReservedNodeType: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceReservedNodeType())
        .map(value => value: String)
    override val sourceReservedNodeCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceReservedNodeCount())
        .map(value => value: Integer)
    override val targetReservedNodeOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetReservedNodeOfferingId())
        .map(value => value: String)
    override val targetReservedNodeType: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetReservedNodeType())
        .map(value => value: String)
    override val targetReservedNodeCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetReservedNodeCount())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus
  ): zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly = new Wrapper(
    impl
  )
}
