package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDataSharesForConsumerResponse(
    dataShares: Optional[Iterable[zio.aws.redshift.model.DataShare]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse = {
    import DescribeDataSharesForConsumerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse
      .builder()
      .optionallyWith(
        dataShares.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataShares)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeDataSharesForConsumerResponse.ReadOnly =
    zio.aws.redshift.model.DescribeDataSharesForConsumerResponse
      .wrap(buildAwsValue())
}
object DescribeDataSharesForConsumerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeDataSharesForConsumerResponse =
      zio.aws.redshift.model.DescribeDataSharesForConsumerResponse(
        dataShares.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def dataShares: Optional[List[zio.aws.redshift.model.DataShare.ReadOnly]]
    def marker: Optional[String]
    def getDataShares
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.DataShare.ReadOnly]] =
      AwsError.unwrapOptionField("dataShares", dataShares)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse
  ) extends zio.aws.redshift.model.DescribeDataSharesForConsumerResponse.ReadOnly {
    override val dataShares
        : Optional[List[zio.aws.redshift.model.DataShare.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataShares())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.DataShare.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse
  ): zio.aws.redshift.model.DescribeDataSharesForConsumerResponse.ReadOnly =
    new Wrapper(impl)
}
