package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DisableSnapshotCopyResponse(
    cluster: Optional[zio.aws.redshift.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse = {
    import DisableSnapshotCopyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DisableSnapshotCopyResponse.ReadOnly =
    zio.aws.redshift.model.DisableSnapshotCopyResponse.wrap(buildAwsValue())
}
object DisableSnapshotCopyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DisableSnapshotCopyResponse =
      zio.aws.redshift.model
        .DisableSnapshotCopyResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.redshift.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse
  ) extends zio.aws.redshift.model.DisableSnapshotCopyResponse.ReadOnly {
    override val cluster: Optional[zio.aws.redshift.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.redshift.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse
  ): zio.aws.redshift.model.DisableSnapshotCopyResponse.ReadOnly = new Wrapper(
    impl
  )
}
