package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait NodeConfigurationOptionsFilterName {
  def unwrap: software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName
}
object NodeConfigurationOptionsFilterName {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName
  ): zio.aws.redshift.model.NodeConfigurationOptionsFilterName = value match {
    case software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName.NODE_TYPE =>
      val r = NodeType
      r
    case software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName.NUMBER_OF_NODES =>
      val r = NumberOfNodes
      r
    case software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName.ESTIMATED_DISK_UTILIZATION_PERCENT =>
      val r = EstimatedDiskUtilizationPercent
      r
    case software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName.MODE =>
      val r = Mode
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.NodeConfigurationOptionsFilterName {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName =
      software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object NodeType
      extends zio.aws.redshift.model.NodeConfigurationOptionsFilterName {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName =
      software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName.NODE_TYPE
  }
  case object NumberOfNodes
      extends zio.aws.redshift.model.NodeConfigurationOptionsFilterName {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName =
      software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName.NUMBER_OF_NODES
  }
  case object EstimatedDiskUtilizationPercent
      extends zio.aws.redshift.model.NodeConfigurationOptionsFilterName {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName =
      software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName.ESTIMATED_DISK_UTILIZATION_PERCENT
  }
  case object Mode
      extends zio.aws.redshift.model.NodeConfigurationOptionsFilterName {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName =
      software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilterName.MODE
  }
}
