package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  CustomDomainCertificateArnString,
  CustomDomainNameString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateCustomDomainAssociationRequest(
    customDomainName: CustomDomainNameString,
    customDomainCertificateArn: CustomDomainCertificateArnString,
    clusterIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationRequest = {
    import CreateCustomDomainAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationRequest
      .builder()
      .customDomainName(
        CustomDomainNameString.unwrap(customDomainName): java.lang.String
      )
      .customDomainCertificateArn(
        CustomDomainCertificateArnString.unwrap(
          customDomainCertificateArn
        ): java.lang.String
      )
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateCustomDomainAssociationRequest.ReadOnly =
    zio.aws.redshift.model.CreateCustomDomainAssociationRequest
      .wrap(buildAwsValue())
}
object CreateCustomDomainAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.CreateCustomDomainAssociationRequest =
      zio.aws.redshift.model.CreateCustomDomainAssociationRequest(
        customDomainName,
        customDomainCertificateArn,
        clusterIdentifier
      )
    def customDomainName: CustomDomainNameString
    def customDomainCertificateArn: CustomDomainCertificateArnString
    def clusterIdentifier: String
    def getCustomDomainName: ZIO[Any, Nothing, CustomDomainNameString] =
      ZIO.succeed(customDomainName)
    def getCustomDomainCertificateArn
        : ZIO[Any, Nothing, CustomDomainCertificateArnString] =
      ZIO.succeed(customDomainCertificateArn)
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationRequest
  ) extends zio.aws.redshift.model.CreateCustomDomainAssociationRequest.ReadOnly {
    override val customDomainName: CustomDomainNameString =
      zio.aws.redshift.model.primitives
        .CustomDomainNameString(impl.customDomainName())
    override val customDomainCertificateArn: CustomDomainCertificateArnString =
      zio.aws.redshift.model.primitives
        .CustomDomainCertificateArnString(impl.customDomainCertificateArn())
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationRequest
  ): zio.aws.redshift.model.CreateCustomDomainAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
