package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClusterParameterStatus(
    parameterName: Optional[String] = Optional.Absent,
    parameterApplyStatus: Optional[String] = Optional.Absent,
    parameterApplyErrorDescription: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterParameterStatus = {
    import ClusterParameterStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterParameterStatus
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(
        parameterApplyStatus.map(value => value: java.lang.String)
      )(_.parameterApplyStatus)
      .optionallyWith(
        parameterApplyErrorDescription.map(value => value: java.lang.String)
      )(_.parameterApplyErrorDescription)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterParameterStatus.ReadOnly =
    zio.aws.redshift.model.ClusterParameterStatus.wrap(buildAwsValue())
}
object ClusterParameterStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterParameterStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterParameterStatus =
      zio.aws.redshift.model.ClusterParameterStatus(
        parameterName.map(value => value),
        parameterApplyStatus.map(value => value),
        parameterApplyErrorDescription.map(value => value)
      )
    def parameterName: Optional[String]
    def parameterApplyStatus: Optional[String]
    def parameterApplyErrorDescription: Optional[String]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterApplyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getParameterApplyErrorDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "parameterApplyErrorDescription",
        parameterApplyErrorDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterStatus
  ) extends zio.aws.redshift.model.ClusterParameterStatus.ReadOnly {
    override val parameterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterName())
      .map(value => value: String)
    override val parameterApplyStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterApplyStatus())
      .map(value => value: String)
    override val parameterApplyErrorDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterApplyErrorDescription())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterStatus
  ): zio.aws.redshift.model.ClusterParameterStatus.ReadOnly = new Wrapper(impl)
}
