package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EnableSnapshotCopyRequest(
    clusterIdentifier: String,
    destinationRegion: String,
    retentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    snapshotCopyGrantName: Optional[String] = Optional.Absent,
    manualSnapshotRetentionPeriod: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest = {
    import EnableSnapshotCopyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .destinationRegion(destinationRegion: java.lang.String)
      .optionallyWith(retentionPeriod.map(value => value: Integer))(
        _.retentionPeriod
      )
      .optionallyWith(
        snapshotCopyGrantName.map(value => value: java.lang.String)
      )(_.snapshotCopyGrantName)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.manualSnapshotRetentionPeriod)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EnableSnapshotCopyRequest.ReadOnly =
    zio.aws.redshift.model.EnableSnapshotCopyRequest.wrap(buildAwsValue())
}
object EnableSnapshotCopyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EnableSnapshotCopyRequest =
      zio.aws.redshift.model.EnableSnapshotCopyRequest(
        clusterIdentifier,
        destinationRegion,
        retentionPeriod.map(value => value),
        snapshotCopyGrantName.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value)
      )
    def clusterIdentifier: String
    def destinationRegion: String
    def retentionPeriod: Optional[IntegerOptional]
    def snapshotCopyGrantName: Optional[String]
    def manualSnapshotRetentionPeriod: Optional[IntegerOptional]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getDestinationRegion: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationRegion)
    def getRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getSnapshotCopyGrantName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotCopyGrantName", snapshotCopyGrantName)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest
  ) extends zio.aws.redshift.model.EnableSnapshotCopyRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val destinationRegion: String = impl.destinationRegion(): String
    override val retentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => value: IntegerOptional)
    override val snapshotCopyGrantName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotCopyGrantName())
      .map(value => value: String)
    override val manualSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest
  ): zio.aws.redshift.model.EnableSnapshotCopyRequest.ReadOnly = new Wrapper(
    impl
  )
}
