package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeCustomDomainAssociationsResponse(
    marker: Optional[String] = Optional.Absent,
    associations: Optional[Iterable[zio.aws.redshift.model.Association]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse = {
    import DescribeCustomDomainAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeCustomDomainAssociationsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeCustomDomainAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeCustomDomainAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeCustomDomainAssociationsResponse =
      zio.aws.redshift.model.DescribeCustomDomainAssociationsResponse(
        marker.map(value => value),
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def associations
        : Optional[List[zio.aws.redshift.model.Association.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.Association.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse
  ) extends zio.aws.redshift.model.DescribeCustomDomainAssociationsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val associations
        : Optional[List[zio.aws.redshift.model.Association.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Association.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse
  ): zio.aws.redshift.model.DescribeCustomDomainAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
