package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class DeferredMaintenanceWindow(
    deferMaintenanceIdentifier: Optional[String] = Optional.Absent,
    deferMaintenanceStartTime: Optional[TStamp] = Optional.Absent,
    deferMaintenanceEndTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow = {
    import DeferredMaintenanceWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow
      .builder()
      .optionallyWith(
        deferMaintenanceIdentifier.map(value => value: java.lang.String)
      )(_.deferMaintenanceIdentifier)
      .optionallyWith(
        deferMaintenanceStartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.deferMaintenanceStartTime)
      .optionallyWith(
        deferMaintenanceEndTime.map(value => TStamp.unwrap(value): Instant)
      )(_.deferMaintenanceEndTime)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly =
    zio.aws.redshift.model.DeferredMaintenanceWindow.wrap(buildAwsValue())
}
object DeferredMaintenanceWindow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeferredMaintenanceWindow =
      zio.aws.redshift.model.DeferredMaintenanceWindow(
        deferMaintenanceIdentifier.map(value => value),
        deferMaintenanceStartTime.map(value => value),
        deferMaintenanceEndTime.map(value => value)
      )
    def deferMaintenanceIdentifier: Optional[String]
    def deferMaintenanceStartTime: Optional[TStamp]
    def deferMaintenanceEndTime: Optional[TStamp]
    def getDeferMaintenanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "deferMaintenanceIdentifier",
        deferMaintenanceIdentifier
      )
    def getDeferMaintenanceStartTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("deferMaintenanceStartTime", deferMaintenanceStartTime)
    def getDeferMaintenanceEndTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("deferMaintenanceEndTime", deferMaintenanceEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow
  ) extends zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly {
    override val deferMaintenanceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deferMaintenanceIdentifier())
        .map(value => value: String)
    override val deferMaintenanceStartTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deferMaintenanceStartTime())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val deferMaintenanceEndTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deferMaintenanceEndTime())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow
  ): zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly = new Wrapper(
    impl
  )
}
