package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateClusterRequest(
    dbName: Optional[String] = Optional.Absent,
    clusterIdentifier: String,
    clusterType: Optional[String] = Optional.Absent,
    nodeType: String,
    masterUsername: String,
    masterUserPassword: String,
    clusterSecurityGroups: Optional[Iterable[String]] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    clusterSubnetGroupName: Optional[String] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    clusterParameterGroupName: Optional[String] = Optional.Absent,
    automatedSnapshotRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent,
    manualSnapshotRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    clusterVersion: Optional[String] = Optional.Absent,
    allowVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    numberOfNodes: Optional[IntegerOptional] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    encrypted: Optional[BooleanOptional] = Optional.Absent,
    hsmClientCertificateIdentifier: Optional[String] = Optional.Absent,
    hsmConfigurationIdentifier: Optional[String] = Optional.Absent,
    elasticIp: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    enhancedVpcRouting: Optional[BooleanOptional] = Optional.Absent,
    additionalInfo: Optional[String] = Optional.Absent,
    iamRoles: Optional[Iterable[String]] = Optional.Absent,
    maintenanceTrackName: Optional[String] = Optional.Absent,
    snapshotScheduleIdentifier: Optional[String] = Optional.Absent,
    availabilityZoneRelocation: Optional[BooleanOptional] = Optional.Absent,
    aquaConfigurationStatus: Optional[
      zio.aws.redshift.model.AquaConfigurationStatus
    ] = Optional.Absent,
    defaultIamRoleArn: Optional[String] = Optional.Absent,
    loadSampleData: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterRequest
      .builder()
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(clusterType.map(value => value: java.lang.String))(
        _.clusterType
      )
      .nodeType(nodeType: java.lang.String)
      .masterUsername(masterUsername: java.lang.String)
      .masterUserPassword(masterUserPassword: java.lang.String)
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        clusterSubnetGroupName.map(value => value: java.lang.String)
      )(_.clusterSubnetGroupName)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        clusterParameterGroupName.map(value => value: java.lang.String)
      )(_.clusterParameterGroupName)
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        allowVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowVersionUpgrade)
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value => value: java.lang.String)
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(
        hsmConfigurationIdentifier.map(value => value: java.lang.String)
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(elasticIp.map(value => value: java.lang.String))(
        _.elasticIp
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .optionallyWith(
        iamRoles.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.iamRoles)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(
        snapshotScheduleIdentifier.map(value => value: java.lang.String)
      )(_.snapshotScheduleIdentifier)
      .optionallyWith(
        availabilityZoneRelocation.map(value => value: java.lang.Boolean)
      )(_.availabilityZoneRelocation)
      .optionallyWith(aquaConfigurationStatus.map(value => value.unwrap))(
        _.aquaConfigurationStatus
      )
      .optionallyWith(defaultIamRoleArn.map(value => value: java.lang.String))(
        _.defaultIamRoleArn
      )
      .optionallyWith(loadSampleData.map(value => value: java.lang.String))(
        _.loadSampleData
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CreateClusterRequest.ReadOnly =
    zio.aws.redshift.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterRequest =
      zio.aws.redshift.model.CreateClusterRequest(
        dbName.map(value => value),
        clusterIdentifier,
        clusterType.map(value => value),
        nodeType,
        masterUsername,
        masterUserPassword,
        clusterSecurityGroups.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        clusterSubnetGroupName.map(value => value),
        availabilityZone.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        clusterParameterGroupName.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        port.map(value => value),
        clusterVersion.map(value => value),
        allowVersionUpgrade.map(value => value),
        numberOfNodes.map(value => value),
        publiclyAccessible.map(value => value),
        encrypted.map(value => value),
        hsmClientCertificateIdentifier.map(value => value),
        hsmConfigurationIdentifier.map(value => value),
        elasticIp.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enhancedVpcRouting.map(value => value),
        additionalInfo.map(value => value),
        iamRoles.map(value => value),
        maintenanceTrackName.map(value => value),
        snapshotScheduleIdentifier.map(value => value),
        availabilityZoneRelocation.map(value => value),
        aquaConfigurationStatus.map(value => value),
        defaultIamRoleArn.map(value => value),
        loadSampleData.map(value => value)
      )
    def dbName: Optional[String]
    def clusterIdentifier: String
    def clusterType: Optional[String]
    def nodeType: String
    def masterUsername: String
    def masterUserPassword: String
    def clusterSecurityGroups: Optional[List[String]]
    def vpcSecurityGroupIds: Optional[List[String]]
    def clusterSubnetGroupName: Optional[String]
    def availabilityZone: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def clusterParameterGroupName: Optional[String]
    def automatedSnapshotRetentionPeriod: Optional[IntegerOptional]
    def manualSnapshotRetentionPeriod: Optional[IntegerOptional]
    def port: Optional[IntegerOptional]
    def clusterVersion: Optional[String]
    def allowVersionUpgrade: Optional[BooleanOptional]
    def numberOfNodes: Optional[IntegerOptional]
    def publiclyAccessible: Optional[BooleanOptional]
    def encrypted: Optional[BooleanOptional]
    def hsmClientCertificateIdentifier: Optional[String]
    def hsmConfigurationIdentifier: Optional[String]
    def elasticIp: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def kmsKeyId: Optional[String]
    def enhancedVpcRouting: Optional[BooleanOptional]
    def additionalInfo: Optional[String]
    def iamRoles: Optional[List[String]]
    def maintenanceTrackName: Optional[String]
    def snapshotScheduleIdentifier: Optional[String]
    def availabilityZoneRelocation: Optional[BooleanOptional]
    def aquaConfigurationStatus
        : Optional[zio.aws.redshift.model.AquaConfigurationStatus]
    def defaultIamRoleArn: Optional[String]
    def loadSampleData: Optional[String]
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getNodeType: ZIO[Any, Nothing, String] = ZIO.succeed(nodeType)
    def getMasterUsername: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterUsername)
    def getMasterUserPassword: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterUserPassword)
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getClusterSubnetGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSubnetGroupName", clusterSubnetGroupName)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getClusterParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterParameterGroupName", clusterParameterGroupName)
    def getAutomatedSnapshotRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "automatedSnapshotRetentionPeriod",
      automatedSnapshotRetentionPeriod
    )
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getAllowVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("allowVersionUpgrade", allowVersionUpgrade)
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getElasticIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("elasticIp", elasticIp)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getIamRoles: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("iamRoles", iamRoles)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getSnapshotScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "snapshotScheduleIdentifier",
        snapshotScheduleIdentifier
      )
    def getAvailabilityZoneRelocation: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "availabilityZoneRelocation",
        availabilityZoneRelocation
      )
    def getAquaConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.AquaConfigurationStatus] =
      AwsError.unwrapOptionField(
        "aquaConfigurationStatus",
        aquaConfigurationStatus
      )
    def getDefaultIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultIamRoleArn", defaultIamRoleArn)
    def getLoadSampleData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("loadSampleData", loadSampleData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterRequest
  ) extends zio.aws.redshift.model.CreateClusterRequest.ReadOnly {
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val clusterType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterType())
      .map(value => value: String)
    override val nodeType: String = impl.nodeType(): String
    override val masterUsername: String = impl.masterUsername(): String
    override val masterUserPassword: String = impl.masterUserPassword(): String
    override val clusterSecurityGroups: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val clusterSubnetGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSubnetGroupName())
        .map(value => value: String)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val clusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterParameterGroupName())
        .map(value => value: String)
    override val automatedSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val manualSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val clusterVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterVersion())
      .map(value => value: String)
    override val allowVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val numberOfNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfNodes())
        .map(value => value: IntegerOptional)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val encrypted: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: BooleanOptional)
    override val hsmClientCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmClientCertificateIdentifier())
        .map(value => value: String)
    override val hsmConfigurationIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmConfigurationIdentifier())
        .map(value => value: String)
    override val elasticIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticIp())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val enhancedVpcRouting: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedVpcRouting())
        .map(value => value: BooleanOptional)
    override val additionalInfo: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInfo())
      .map(value => value: String)
    override val iamRoles: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoles())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maintenanceTrackName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceTrackName())
      .map(value => value: String)
    override val snapshotScheduleIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotScheduleIdentifier())
        .map(value => value: String)
    override val availabilityZoneRelocation: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneRelocation())
        .map(value => value: BooleanOptional)
    override val aquaConfigurationStatus
        : Optional[zio.aws.redshift.model.AquaConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aquaConfigurationStatus())
        .map(value =>
          zio.aws.redshift.model.AquaConfigurationStatus.wrap(value)
        )
    override val defaultIamRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultIamRoleArn())
      .map(value => value: String)
    override val loadSampleData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.loadSampleData())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterRequest
  ): zio.aws.redshift.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
