package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class Association(
    customDomainCertificateArn: Optional[String] = Optional.Absent,
    customDomainCertificateExpiryDate: Optional[TStamp] = Optional.Absent,
    certificateAssociations: Optional[
      Iterable[zio.aws.redshift.model.CertificateAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.Association = {
    import Association.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.Association
      .builder()
      .optionallyWith(
        customDomainCertificateArn.map(value => value: java.lang.String)
      )(_.customDomainCertificateArn)
      .optionallyWith(
        customDomainCertificateExpiryDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.customDomainCertificateExpiryDate)
      .optionallyWith(
        certificateAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificateAssociations)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.Association.ReadOnly =
    zio.aws.redshift.model.Association.wrap(buildAwsValue())
}
object Association {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.Association
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.Association =
      zio.aws.redshift.model.Association(
        customDomainCertificateArn.map(value => value),
        customDomainCertificateExpiryDate.map(value => value),
        certificateAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customDomainCertificateArn: Optional[String]
    def customDomainCertificateExpiryDate: Optional[TStamp]
    def certificateAssociations
        : Optional[List[zio.aws.redshift.model.CertificateAssociation.ReadOnly]]
    def getCustomDomainCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "customDomainCertificateArn",
        customDomainCertificateArn
      )
    def getCustomDomainCertificateExpiryDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "customDomainCertificateExpiryDate",
        customDomainCertificateExpiryDate
      )
    def getCertificateAssociations: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.CertificateAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "certificateAssociations",
      certificateAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.Association
  ) extends zio.aws.redshift.model.Association.ReadOnly {
    override val customDomainCertificateArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainCertificateArn())
        .map(value => value: String)
    override val customDomainCertificateExpiryDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainCertificateExpiryDate())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val certificateAssociations: Optional[
      List[zio.aws.redshift.model.CertificateAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.CertificateAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.Association
  ): zio.aws.redshift.model.Association.ReadOnly = new Wrapper(impl)
}
