package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeReservedNodeExchangeStatusResponse(
    reservedNodeExchangeStatusDetails: Optional[
      Iterable[zio.aws.redshift.model.ReservedNodeExchangeStatus]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse = {
    import DescribeReservedNodeExchangeStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse
      .builder()
      .optionallyWith(
        reservedNodeExchangeStatusDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedNodeExchangeStatusDetails)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse.ReadOnly =
    zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse
      .wrap(buildAwsValue())
}
object DescribeReservedNodeExchangeStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse =
      zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse(
        reservedNodeExchangeStatusDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def reservedNodeExchangeStatusDetails: Optional[
      List[zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly]
    ]
    def marker: Optional[String]
    def getReservedNodeExchangeStatusDetails: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedNodeExchangeStatusDetails",
      reservedNodeExchangeStatusDetails
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse
  ) extends zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse.ReadOnly {
    override val reservedNodeExchangeStatusDetails: Optional[
      List[zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedNodeExchangeStatusDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ReservedNodeExchangeStatus.wrap(item)
        }.toList
      )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse
  ): zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse.ReadOnly =
    new Wrapper(impl)
}
