package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ResizeClusterMessage(
    clusterIdentifier: String,
    clusterType: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    numberOfNodes: Optional[IntegerOptional] = Optional.Absent,
    classic: Optional[BooleanOptional] = Optional.Absent,
    reservedNodeId: Optional[String] = Optional.Absent,
    targetReservedNodeOfferingId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ResizeClusterMessage = {
    import ResizeClusterMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ResizeClusterMessage
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(clusterType.map(value => value: java.lang.String))(
        _.clusterType
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .optionallyWith(classic.map(value => value: java.lang.Boolean))(_.classic)
      .optionallyWith(reservedNodeId.map(value => value: java.lang.String))(
        _.reservedNodeId
      )
      .optionallyWith(
        targetReservedNodeOfferingId.map(value => value: java.lang.String)
      )(_.targetReservedNodeOfferingId)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ResizeClusterMessage.ReadOnly =
    zio.aws.redshift.model.ResizeClusterMessage.wrap(buildAwsValue())
}
object ResizeClusterMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ResizeClusterMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ResizeClusterMessage =
      zio.aws.redshift.model.ResizeClusterMessage(
        clusterIdentifier,
        clusterType.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        classic.map(value => value),
        reservedNodeId.map(value => value),
        targetReservedNodeOfferingId.map(value => value)
      )
    def clusterIdentifier: String
    def clusterType: Optional[String]
    def nodeType: Optional[String]
    def numberOfNodes: Optional[IntegerOptional]
    def classic: Optional[BooleanOptional]
    def reservedNodeId: Optional[String]
    def targetReservedNodeOfferingId: Optional[String]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getClassic: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("classic", classic)
    def getReservedNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedNodeId", reservedNodeId)
    def getTargetReservedNodeOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetReservedNodeOfferingId",
        targetReservedNodeOfferingId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ResizeClusterMessage
  ) extends zio.aws.redshift.model.ResizeClusterMessage.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val clusterType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterType())
      .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val numberOfNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfNodes())
        .map(value => value: IntegerOptional)
    override val classic: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.classic())
      .map(value => value: BooleanOptional)
    override val reservedNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedNodeId())
      .map(value => value: String)
    override val targetReservedNodeOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetReservedNodeOfferingId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ResizeClusterMessage
  ): zio.aws.redshift.model.ResizeClusterMessage.ReadOnly = new Wrapper(impl)
}
