package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class Event(
    sourceIdentifier: Optional[String] = Optional.Absent,
    sourceType: Optional[zio.aws.redshift.model.SourceType] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    eventCategories: Optional[Iterable[String]] = Optional.Absent,
    severity: Optional[String] = Optional.Absent,
    date: Optional[TStamp] = Optional.Absent,
    eventId: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.redshift.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.Event
      .builder()
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(severity.map(value => value: java.lang.String))(
        _.severity
      )
      .optionallyWith(date.map(value => TStamp.unwrap(value): Instant))(_.date)
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.Event.ReadOnly =
    zio.aws.redshift.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.redshift.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.Event = zio.aws.redshift.model.Event(
      sourceIdentifier.map(value => value),
      sourceType.map(value => value),
      message.map(value => value),
      eventCategories.map(value => value),
      severity.map(value => value),
      date.map(value => value),
      eventId.map(value => value)
    )
    def sourceIdentifier: Optional[String]
    def sourceType: Optional[zio.aws.redshift.model.SourceType]
    def message: Optional[String]
    def eventCategories: Optional[List[String]]
    def severity: Optional[String]
    def date: Optional[TStamp]
    def eventId: Optional[String]
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceType: ZIO[Any, AwsError, zio.aws.redshift.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getSeverity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("severity", severity)
    def getDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("date", date)
    def getEventId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventId", eventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.Event
  ) extends zio.aws.redshift.model.Event.ReadOnly {
    override val sourceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIdentifier())
      .map(value => value: String)
    override val sourceType: Optional[zio.aws.redshift.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.redshift.model.SourceType.wrap(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val eventCategories: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val severity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => value: String)
    override val date: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val eventId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.Event
  ): zio.aws.redshift.model.Event.ReadOnly = new Wrapper(impl)
}
