package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{DoubleOptional, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NodeConfigurationOption(
    nodeType: Optional[String] = Optional.Absent,
    numberOfNodes: Optional[Integer] = Optional.Absent,
    estimatedDiskUtilizationPercent: Optional[DoubleOptional] = Optional.Absent,
    mode: Optional[zio.aws.redshift.model.Mode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.NodeConfigurationOption = {
    import NodeConfigurationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.NodeConfigurationOption
      .builder()
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(numberOfNodes.map(value => value: java.lang.Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        estimatedDiskUtilizationPercent.map(value => value: java.lang.Double)
      )(_.estimatedDiskUtilizationPercent)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.NodeConfigurationOption.ReadOnly =
    zio.aws.redshift.model.NodeConfigurationOption.wrap(buildAwsValue())
}
object NodeConfigurationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.NodeConfigurationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.NodeConfigurationOption =
      zio.aws.redshift.model.NodeConfigurationOption(
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        estimatedDiskUtilizationPercent.map(value => value),
        mode.map(value => value)
      )
    def nodeType: Optional[String]
    def numberOfNodes: Optional[Integer]
    def estimatedDiskUtilizationPercent: Optional[DoubleOptional]
    def mode: Optional[zio.aws.redshift.model.Mode]
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getEstimatedDiskUtilizationPercent: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField(
        "estimatedDiskUtilizationPercent",
        estimatedDiskUtilizationPercent
      )
    def getMode: ZIO[Any, AwsError, zio.aws.redshift.model.Mode] =
      AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.NodeConfigurationOption
  ) extends zio.aws.redshift.model.NodeConfigurationOption.ReadOnly {
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val numberOfNodes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfNodes())
      .map(value => value: Integer)
    override val estimatedDiskUtilizationPercent: Optional[DoubleOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedDiskUtilizationPercent())
        .map(value => value: DoubleOptional)
    override val mode: Optional[zio.aws.redshift.model.Mode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.redshift.model.Mode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.NodeConfigurationOption
  ): zio.aws.redshift.model.NodeConfigurationOption.ReadOnly = new Wrapper(impl)
}
