package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class ClusterDbRevision(
    clusterIdentifier: Optional[String] = Optional.Absent,
    currentDatabaseRevision: Optional[String] = Optional.Absent,
    databaseRevisionReleaseDate: Optional[TStamp] = Optional.Absent,
    revisionTargets: Optional[Iterable[zio.aws.redshift.model.RevisionTarget]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterDbRevision = {
    import ClusterDbRevision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterDbRevision
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(
        currentDatabaseRevision.map(value => value: java.lang.String)
      )(_.currentDatabaseRevision)
      .optionallyWith(
        databaseRevisionReleaseDate.map(value => TStamp.unwrap(value): Instant)
      )(_.databaseRevisionReleaseDate)
      .optionallyWith(
        revisionTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.revisionTargets)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterDbRevision.ReadOnly =
    zio.aws.redshift.model.ClusterDbRevision.wrap(buildAwsValue())
}
object ClusterDbRevision {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterDbRevision
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterDbRevision =
      zio.aws.redshift.model.ClusterDbRevision(
        clusterIdentifier.map(value => value),
        currentDatabaseRevision.map(value => value),
        databaseRevisionReleaseDate.map(value => value),
        revisionTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterIdentifier: Optional[String]
    def currentDatabaseRevision: Optional[String]
    def databaseRevisionReleaseDate: Optional[TStamp]
    def revisionTargets
        : Optional[List[zio.aws.redshift.model.RevisionTarget.ReadOnly]]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getCurrentDatabaseRevision: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("currentDatabaseRevision", currentDatabaseRevision)
    def getDatabaseRevisionReleaseDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "databaseRevisionReleaseDate",
        databaseRevisionReleaseDate
      )
    def getRevisionTargets: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.RevisionTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("revisionTargets", revisionTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterDbRevision
  ) extends zio.aws.redshift.model.ClusterDbRevision.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val currentDatabaseRevision: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentDatabaseRevision())
        .map(value => value: String)
    override val databaseRevisionReleaseDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseRevisionReleaseDate())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val revisionTargets
        : Optional[List[zio.aws.redshift.model.RevisionTarget.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.RevisionTarget.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterDbRevision
  ): zio.aws.redshift.model.ClusterDbRevision.ReadOnly = new Wrapper(impl)
}
