package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeHsmClientCertificatesRequest(
    hsmClientCertificateIdentifier: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    tagKeys: Optional[Iterable[String]] = Optional.Absent,
    tagValues: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest = {
    import DescribeHsmClientCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest
      .builder()
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value => value: java.lang.String)
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeHsmClientCertificatesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeHsmClientCertificatesRequest
      .wrap(buildAwsValue())
}
object DescribeHsmClientCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeHsmClientCertificatesRequest =
      zio.aws.redshift.model.DescribeHsmClientCertificatesRequest(
        hsmClientCertificateIdentifier.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value)
      )
    def hsmClientCertificateIdentifier: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def tagKeys: Optional[List[String]]
    def tagValues: Optional[List[String]]
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest
  ) extends zio.aws.redshift.model.DescribeHsmClientCertificatesRequest.ReadOnly {
    override val hsmClientCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmClientCertificateIdentifier())
        .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val tagKeys: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest
  ): zio.aws.redshift.model.DescribeHsmClientCertificatesRequest.ReadOnly =
    new Wrapper(impl)
}
