package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PurchaseReservedNodeOfferingRequest(
    reservedNodeOfferingId: String,
    nodeCount: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest = {
    import PurchaseReservedNodeOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest
      .builder()
      .reservedNodeOfferingId(reservedNodeOfferingId: java.lang.String)
      .optionallyWith(nodeCount.map(value => value: Integer))(_.nodeCount)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest.ReadOnly =
    zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest
      .wrap(buildAwsValue())
}
object PurchaseReservedNodeOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest =
      zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest(
        reservedNodeOfferingId,
        nodeCount.map(value => value)
      )
    def reservedNodeOfferingId: String
    def nodeCount: Optional[IntegerOptional]
    def getReservedNodeOfferingId: ZIO[Any, Nothing, String] =
      ZIO.succeed(reservedNodeOfferingId)
    def getNodeCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("nodeCount", nodeCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest
  ) extends zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest.ReadOnly {
    override val reservedNodeOfferingId: String =
      impl.reservedNodeOfferingId(): String
    override val nodeCount: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeCount())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest
  ): zio.aws.redshift.model.PurchaseReservedNodeOfferingRequest.ReadOnly =
    new Wrapper(impl)
}
