package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClusterParameterGroupStatus(
    parameterGroupName: Optional[String] = Optional.Absent,
    parameterApplyStatus: Optional[String] = Optional.Absent,
    clusterParameterStatusList: Optional[
      Iterable[zio.aws.redshift.model.ClusterParameterStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus = {
    import ClusterParameterGroupStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        parameterApplyStatus.map(value => value: java.lang.String)
      )(_.parameterApplyStatus)
      .optionallyWith(
        clusterParameterStatusList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterParameterStatusList)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly =
    zio.aws.redshift.model.ClusterParameterGroupStatus.wrap(buildAwsValue())
}
object ClusterParameterGroupStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterParameterGroupStatus =
      zio.aws.redshift.model.ClusterParameterGroupStatus(
        parameterGroupName.map(value => value),
        parameterApplyStatus.map(value => value),
        clusterParameterStatusList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parameterGroupName: Optional[String]
    def parameterApplyStatus: Optional[String]
    def clusterParameterStatusList
        : Optional[List[zio.aws.redshift.model.ClusterParameterStatus.ReadOnly]]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getParameterApplyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getClusterParameterStatusList: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterParameterStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "clusterParameterStatusList",
      clusterParameterStatusList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus
  ) extends zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly {
    override val parameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupName())
      .map(value => value: String)
    override val parameterApplyStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterApplyStatus())
      .map(value => value: String)
    override val clusterParameterStatusList: Optional[
      List[zio.aws.redshift.model.ClusterParameterStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterParameterStatusList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterParameterStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus
  ): zio.aws.redshift.model.ClusterParameterGroupStatus.ReadOnly = new Wrapper(
    impl
  )
}
