package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchDeleteClusterSnapshotsResponse(
    resources: Optional[Iterable[String]] = Optional.Absent,
    errors: Optional[Iterable[zio.aws.redshift.model.SnapshotErrorMessage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse = {
    import BatchDeleteClusterSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse.ReadOnly =
    zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse
      .wrap(buildAwsValue())
}
object BatchDeleteClusterSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse =
      zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse(
        resources.map(value => value),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resources: Optional[List[String]]
    def errors
        : Optional[List[zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly]]
    def getResources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resources", resources)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse
  ) extends zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse.ReadOnly {
    override val resources: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val errors
        : Optional[List[zio.aws.redshift.model.SnapshotErrorMessage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.SnapshotErrorMessage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse
  ): zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
