package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcEndpoint(
    vpcEndpointId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.redshift.model.NetworkInterface]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.VpcEndpoint = {
    import VpcEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.VpcEndpoint
      .builder()
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.VpcEndpoint.ReadOnly =
    zio.aws.redshift.model.VpcEndpoint.wrap(buildAwsValue())
}
object VpcEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.VpcEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.VpcEndpoint =
      zio.aws.redshift.model.VpcEndpoint(
        vpcEndpointId.map(value => value),
        vpcId.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpcEndpointId: Optional[String]
    def vpcId: Optional[String]
    def networkInterfaces
        : Optional[List[zio.aws.redshift.model.NetworkInterface.ReadOnly]]
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.VpcEndpoint
  ) extends zio.aws.redshift.model.VpcEndpoint.ReadOnly {
    override val vpcEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val networkInterfaces
        : Optional[List[zio.aws.redshift.model.NetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.NetworkInterface.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.VpcEndpoint
  ): zio.aws.redshift.model.VpcEndpoint.ReadOnly = new Wrapper(impl)
}
