package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  PartnerIntegrationClusterIdentifier,
  PartnerIntegrationDatabaseName,
  PartnerIntegrationPartnerName,
  PartnerIntegrationStatusMessage,
  PartnerIntegrationAccountId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePartnerStatusRequest(
    accountId: PartnerIntegrationAccountId,
    clusterIdentifier: PartnerIntegrationClusterIdentifier,
    databaseName: PartnerIntegrationDatabaseName,
    partnerName: PartnerIntegrationPartnerName,
    status: zio.aws.redshift.model.PartnerIntegrationStatus,
    statusMessage: Optional[PartnerIntegrationStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusRequest = {
    import UpdatePartnerStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusRequest
      .builder()
      .accountId(
        PartnerIntegrationAccountId.unwrap(accountId): java.lang.String
      )
      .clusterIdentifier(
        PartnerIntegrationClusterIdentifier.unwrap(
          clusterIdentifier
        ): java.lang.String
      )
      .databaseName(
        PartnerIntegrationDatabaseName.unwrap(databaseName): java.lang.String
      )
      .partnerName(
        PartnerIntegrationPartnerName.unwrap(partnerName): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          PartnerIntegrationStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.UpdatePartnerStatusRequest.ReadOnly =
    zio.aws.redshift.model.UpdatePartnerStatusRequest.wrap(buildAwsValue())
}
object UpdatePartnerStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.UpdatePartnerStatusRequest =
      zio.aws.redshift.model.UpdatePartnerStatusRequest(
        accountId,
        clusterIdentifier,
        databaseName,
        partnerName,
        status,
        statusMessage.map(value => value)
      )
    def accountId: PartnerIntegrationAccountId
    def clusterIdentifier: PartnerIntegrationClusterIdentifier
    def databaseName: PartnerIntegrationDatabaseName
    def partnerName: PartnerIntegrationPartnerName
    def status: zio.aws.redshift.model.PartnerIntegrationStatus
    def statusMessage: Optional[PartnerIntegrationStatusMessage]
    def getAccountId: ZIO[Any, Nothing, PartnerIntegrationAccountId] =
      ZIO.succeed(accountId)
    def getClusterIdentifier
        : ZIO[Any, Nothing, PartnerIntegrationClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getDatabaseName: ZIO[Any, Nothing, PartnerIntegrationDatabaseName] =
      ZIO.succeed(databaseName)
    def getPartnerName: ZIO[Any, Nothing, PartnerIntegrationPartnerName] =
      ZIO.succeed(partnerName)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.redshift.model.PartnerIntegrationStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, PartnerIntegrationStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusRequest
  ) extends zio.aws.redshift.model.UpdatePartnerStatusRequest.ReadOnly {
    override val accountId: PartnerIntegrationAccountId =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationAccountId(impl.accountId())
    override val clusterIdentifier: PartnerIntegrationClusterIdentifier =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationClusterIdentifier(impl.clusterIdentifier())
    override val databaseName: PartnerIntegrationDatabaseName =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationDatabaseName(impl.databaseName())
    override val partnerName: PartnerIntegrationPartnerName =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationPartnerName(impl.partnerName())
    override val status: zio.aws.redshift.model.PartnerIntegrationStatus =
      zio.aws.redshift.model.PartnerIntegrationStatus.wrap(impl.status())
    override val statusMessage: Optional[PartnerIntegrationStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.redshift.model.primitives
            .PartnerIntegrationStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusRequest
  ): zio.aws.redshift.model.UpdatePartnerStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
