package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifyClusterRequest(
    clusterIdentifier: String,
    clusterType: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    numberOfNodes: Optional[IntegerOptional] = Optional.Absent,
    clusterSecurityGroups: Optional[Iterable[String]] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    clusterParameterGroupName: Optional[String] = Optional.Absent,
    automatedSnapshotRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent,
    manualSnapshotRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    clusterVersion: Optional[String] = Optional.Absent,
    allowVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    hsmClientCertificateIdentifier: Optional[String] = Optional.Absent,
    hsmConfigurationIdentifier: Optional[String] = Optional.Absent,
    newClusterIdentifier: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    elasticIp: Optional[String] = Optional.Absent,
    enhancedVpcRouting: Optional[BooleanOptional] = Optional.Absent,
    maintenanceTrackName: Optional[String] = Optional.Absent,
    encrypted: Optional[BooleanOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    availabilityZoneRelocation: Optional[BooleanOptional] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterRequest = {
    import ModifyClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(clusterType.map(value => value: java.lang.String))(
        _.clusterType
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        clusterParameterGroupName.map(value => value: java.lang.String)
      )(_.clusterParameterGroupName)
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        allowVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowVersionUpgrade)
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value => value: java.lang.String)
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(
        hsmConfigurationIdentifier.map(value => value: java.lang.String)
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(
        newClusterIdentifier.map(value => value: java.lang.String)
      )(_.newClusterIdentifier)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(elasticIp.map(value => value: java.lang.String))(
        _.elasticIp
      )
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        availabilityZoneRelocation.map(value => value: java.lang.Boolean)
      )(_.availabilityZoneRelocation)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ModifyClusterRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterRequest.wrap(buildAwsValue())
}
object ModifyClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterRequest =
      zio.aws.redshift.model.ModifyClusterRequest(
        clusterIdentifier,
        clusterType.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        clusterSecurityGroups.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        masterUserPassword.map(value => value),
        clusterParameterGroupName.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        clusterVersion.map(value => value),
        allowVersionUpgrade.map(value => value),
        hsmClientCertificateIdentifier.map(value => value),
        hsmConfigurationIdentifier.map(value => value),
        newClusterIdentifier.map(value => value),
        publiclyAccessible.map(value => value),
        elasticIp.map(value => value),
        enhancedVpcRouting.map(value => value),
        maintenanceTrackName.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        availabilityZoneRelocation.map(value => value),
        availabilityZone.map(value => value),
        port.map(value => value)
      )
    def clusterIdentifier: String
    def clusterType: Optional[String]
    def nodeType: Optional[String]
    def numberOfNodes: Optional[IntegerOptional]
    def clusterSecurityGroups: Optional[List[String]]
    def vpcSecurityGroupIds: Optional[List[String]]
    def masterUserPassword: Optional[String]
    def clusterParameterGroupName: Optional[String]
    def automatedSnapshotRetentionPeriod: Optional[IntegerOptional]
    def manualSnapshotRetentionPeriod: Optional[IntegerOptional]
    def preferredMaintenanceWindow: Optional[String]
    def clusterVersion: Optional[String]
    def allowVersionUpgrade: Optional[BooleanOptional]
    def hsmClientCertificateIdentifier: Optional[String]
    def hsmConfigurationIdentifier: Optional[String]
    def newClusterIdentifier: Optional[String]
    def publiclyAccessible: Optional[BooleanOptional]
    def elasticIp: Optional[String]
    def enhancedVpcRouting: Optional[BooleanOptional]
    def maintenanceTrackName: Optional[String]
    def encrypted: Optional[BooleanOptional]
    def kmsKeyId: Optional[String]
    def availabilityZoneRelocation: Optional[BooleanOptional]
    def availabilityZone: Optional[String]
    def port: Optional[IntegerOptional]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getClusterParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterParameterGroupName", clusterParameterGroupName)
    def getAutomatedSnapshotRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "automatedSnapshotRetentionPeriod",
      automatedSnapshotRetentionPeriod
    )
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getAllowVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("allowVersionUpgrade", allowVersionUpgrade)
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getNewClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newClusterIdentifier", newClusterIdentifier)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getElasticIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("elasticIp", elasticIp)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getAvailabilityZoneRelocation: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "availabilityZoneRelocation",
        availabilityZoneRelocation
      )
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterRequest
  ) extends zio.aws.redshift.model.ModifyClusterRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val clusterType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterType())
      .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val numberOfNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfNodes())
        .map(value => value: IntegerOptional)
    override val clusterSecurityGroups: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val clusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterParameterGroupName())
        .map(value => value: String)
    override val automatedSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val manualSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val clusterVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterVersion())
      .map(value => value: String)
    override val allowVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val hsmClientCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmClientCertificateIdentifier())
        .map(value => value: String)
    override val hsmConfigurationIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmConfigurationIdentifier())
        .map(value => value: String)
    override val newClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.newClusterIdentifier())
      .map(value => value: String)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val elasticIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticIp())
      .map(value => value: String)
    override val enhancedVpcRouting: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedVpcRouting())
        .map(value => value: BooleanOptional)
    override val maintenanceTrackName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceTrackName())
      .map(value => value: String)
    override val encrypted: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: BooleanOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val availabilityZoneRelocation: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneRelocation())
        .map(value => value: BooleanOptional)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterRequest
  ): zio.aws.redshift.model.ModifyClusterRequest.ReadOnly = new Wrapper(impl)
}
