package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSnapshotScheduleRequest(scheduleIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest = {
    import DeleteSnapshotScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest
      .builder()
      .scheduleIdentifier(scheduleIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DeleteSnapshotScheduleRequest.ReadOnly =
    zio.aws.redshift.model.DeleteSnapshotScheduleRequest.wrap(buildAwsValue())
}
object DeleteSnapshotScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteSnapshotScheduleRequest =
      zio.aws.redshift.model.DeleteSnapshotScheduleRequest(scheduleIdentifier)
    def scheduleIdentifier: String
    def getScheduleIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(scheduleIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest
  ) extends zio.aws.redshift.model.DeleteSnapshotScheduleRequest.ReadOnly {
    override val scheduleIdentifier: String = impl.scheduleIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest
  ): zio.aws.redshift.model.DeleteSnapshotScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
