package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeReservedNodeExchangeStatusRequest(
    reservedNodeId: Optional[String] = Optional.Absent,
    reservedNodeExchangeRequestId: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest = {
    import DescribeReservedNodeExchangeStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest
      .builder()
      .optionallyWith(reservedNodeId.map(value => value: java.lang.String))(
        _.reservedNodeId
      )
      .optionallyWith(
        reservedNodeExchangeRequestId.map(value => value: java.lang.String)
      )(_.reservedNodeExchangeRequestId)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest.ReadOnly =
    zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest
      .wrap(buildAwsValue())
}
object DescribeReservedNodeExchangeStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest =
      zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest(
        reservedNodeId.map(value => value),
        reservedNodeExchangeRequestId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def reservedNodeId: Optional[String]
    def reservedNodeExchangeRequestId: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getReservedNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedNodeId", reservedNodeId)
    def getReservedNodeExchangeRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedNodeExchangeRequestId",
        reservedNodeExchangeRequestId
      )
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest
  ) extends zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest.ReadOnly {
    override val reservedNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedNodeId())
      .map(value => value: String)
    override val reservedNodeExchangeRequestId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodeExchangeRequestId())
        .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest
  ): zio.aws.redshift.model.DescribeReservedNodeExchangeStatusRequest.ReadOnly =
    new Wrapper(impl)
}
