package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeDataSharesForProducerRequest(
    producerArn: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.redshift.model.DataShareStatusForProducer] =
      Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest = {
    import DescribeDataSharesForProducerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest
      .builder()
      .optionallyWith(producerArn.map(value => value: java.lang.String))(
        _.producerArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeDataSharesForProducerRequest.ReadOnly =
    zio.aws.redshift.model.DescribeDataSharesForProducerRequest
      .wrap(buildAwsValue())
}
object DescribeDataSharesForProducerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeDataSharesForProducerRequest =
      zio.aws.redshift.model.DescribeDataSharesForProducerRequest(
        producerArn.map(value => value),
        status.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def producerArn: Optional[String]
    def status: Optional[zio.aws.redshift.model.DataShareStatusForProducer]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getProducerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("producerArn", producerArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.DataShareStatusForProducer
    ] = AwsError.unwrapOptionField("status", status)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest
  ) extends zio.aws.redshift.model.DescribeDataSharesForProducerRequest.ReadOnly {
    override val producerArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.producerArn())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.redshift.model.DataShareStatusForProducer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.redshift.model.DataShareStatusForProducer.wrap(value)
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest
  ): zio.aws.redshift.model.DescribeDataSharesForProducerRequest.ReadOnly =
    new Wrapper(impl)
}
