package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateClusterSecurityGroupRequest(
    clusterSecurityGroupName: String,
    description: String,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest = {
    import CreateClusterSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest
      .builder()
      .clusterSecurityGroupName(clusterSecurityGroupName: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateClusterSecurityGroupRequest.ReadOnly =
    zio.aws.redshift.model.CreateClusterSecurityGroupRequest
      .wrap(buildAwsValue())
}
object CreateClusterSecurityGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterSecurityGroupRequest =
      zio.aws.redshift.model.CreateClusterSecurityGroupRequest(
        clusterSecurityGroupName,
        description,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterSecurityGroupName: String
    def description: String
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getClusterSecurityGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterSecurityGroupName)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest
  ) extends zio.aws.redshift.model.CreateClusterSecurityGroupRequest.ReadOnly {
    override val clusterSecurityGroupName: String =
      impl.clusterSecurityGroupName(): String
    override val description: String = impl.description(): String
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest
  ): zio.aws.redshift.model.CreateClusterSecurityGroupRequest.ReadOnly =
    new Wrapper(impl)
}
