package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{Integer, TStamp}
import scala.jdk.CollectionConverters.*
final case class ReservedNode(
    reservedNodeId: Optional[String] = Optional.Absent,
    reservedNodeOfferingId: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    startTime: Optional[TStamp] = Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    fixedPrice: Optional[Double] = Optional.Absent,
    usagePrice: Optional[Double] = Optional.Absent,
    currencyCode: Optional[String] = Optional.Absent,
    nodeCount: Optional[Integer] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    offeringType: Optional[String] = Optional.Absent,
    recurringCharges: Optional[
      Iterable[zio.aws.redshift.model.RecurringCharge]
    ] = Optional.Absent,
    reservedNodeOfferingType: Optional[
      zio.aws.redshift.model.ReservedNodeOfferingType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ReservedNode = {
    import ReservedNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ReservedNode
      .builder()
      .optionallyWith(reservedNodeId.map(value => value: java.lang.String))(
        _.reservedNodeId
      )
      .optionallyWith(
        reservedNodeOfferingId.map(value => value: java.lang.String)
      )(_.reservedNodeOfferingId)
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(nodeCount.map(value => value: java.lang.Integer))(
        _.nodeCount
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(reservedNodeOfferingType.map(value => value.unwrap))(
        _.reservedNodeOfferingType
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ReservedNode.ReadOnly =
    zio.aws.redshift.model.ReservedNode.wrap(buildAwsValue())
}
object ReservedNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ReservedNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ReservedNode =
      zio.aws.redshift.model.ReservedNode(
        reservedNodeId.map(value => value),
        reservedNodeOfferingId.map(value => value),
        nodeType.map(value => value),
        startTime.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        nodeCount.map(value => value),
        state.map(value => value),
        offeringType.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedNodeOfferingType.map(value => value)
      )
    def reservedNodeId: Optional[String]
    def reservedNodeOfferingId: Optional[String]
    def nodeType: Optional[String]
    def startTime: Optional[TStamp]
    def duration: Optional[Integer]
    def fixedPrice: Optional[Double]
    def usagePrice: Optional[Double]
    def currencyCode: Optional[String]
    def nodeCount: Optional[Integer]
    def state: Optional[String]
    def offeringType: Optional[String]
    def recurringCharges
        : Optional[List[zio.aws.redshift.model.RecurringCharge.ReadOnly]]
    def reservedNodeOfferingType
        : Optional[zio.aws.redshift.model.ReservedNodeOfferingType]
    def getReservedNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedNodeId", reservedNodeId)
    def getReservedNodeOfferingId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("reservedNodeOfferingId", reservedNodeOfferingId)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getNodeCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nodeCount", nodeCount)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getReservedNodeOfferingType
        : ZIO[Any, AwsError, zio.aws.redshift.model.ReservedNodeOfferingType] =
      AwsError.unwrapOptionField(
        "reservedNodeOfferingType",
        reservedNodeOfferingType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNode
  ) extends zio.aws.redshift.model.ReservedNode.ReadOnly {
    override val reservedNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedNodeId())
      .map(value => value: String)
    override val reservedNodeOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodeOfferingId())
        .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val startTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val fixedPrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Double)
    override val usagePrice: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePrice())
      .map(value => value: Double)
    override val currencyCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currencyCode())
      .map(value => value: String)
    override val nodeCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeCount())
      .map(value => value: Integer)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val offeringType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringType())
      .map(value => value: String)
    override val recurringCharges
        : Optional[List[zio.aws.redshift.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.RecurringCharge.wrap(item)
          }.toList
        )
    override val reservedNodeOfferingType
        : Optional[zio.aws.redshift.model.ReservedNodeOfferingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodeOfferingType())
        .map(value =>
          zio.aws.redshift.model.ReservedNodeOfferingType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ReservedNode
  ): zio.aws.redshift.model.ReservedNode.ReadOnly = new Wrapper(impl)
}
