package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyEndpointAccessRequest(
    endpointName: String,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessRequest = {
    import ModifyEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessRequest
      .builder()
      .endpointName(endpointName: java.lang.String)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ModifyEndpointAccessRequest.ReadOnly =
    zio.aws.redshift.model.ModifyEndpointAccessRequest.wrap(buildAwsValue())
}
object ModifyEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyEndpointAccessRequest =
      zio.aws.redshift.model.ModifyEndpointAccessRequest(
        endpointName,
        vpcSecurityGroupIds.map(value => value)
      )
    def endpointName: String
    def vpcSecurityGroupIds: Optional[List[String]]
    def getEndpointName: ZIO[Any, Nothing, String] = ZIO.succeed(endpointName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessRequest
  ) extends zio.aws.redshift.model.ModifyEndpointAccessRequest.ReadOnly {
    override val endpointName: String = impl.endpointName(): String
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessRequest
  ): zio.aws.redshift.model.ModifyEndpointAccessRequest.ReadOnly = new Wrapper(
    impl
  )
}
