package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeTagsResponse(
    taggedResources: Optional[Iterable[zio.aws.redshift.model.TaggedResource]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeTagsResponse = {
    import DescribeTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeTagsResponse
      .builder()
      .optionallyWith(
        taggedResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taggedResources)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeTagsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeTagsResponse.wrap(buildAwsValue())
}
object DescribeTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeTagsResponse =
      zio.aws.redshift.model.DescribeTagsResponse(
        taggedResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def taggedResources
        : Optional[List[zio.aws.redshift.model.TaggedResource.ReadOnly]]
    def marker: Optional[String]
    def getTaggedResources: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.TaggedResource.ReadOnly
    ]] = AwsError.unwrapOptionField("taggedResources", taggedResources)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeTagsResponse
  ) extends zio.aws.redshift.model.DescribeTagsResponse.ReadOnly {
    override val taggedResources
        : Optional[List[zio.aws.redshift.model.TaggedResource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taggedResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.TaggedResource.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeTagsResponse
  ): zio.aws.redshift.model.DescribeTagsResponse.ReadOnly = new Wrapper(impl)
}
