package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeNodeConfigurationOptionsRequest(
    actionType: zio.aws.redshift.model.ActionType,
    clusterIdentifier: Optional[String] = Optional.Absent,
    snapshotIdentifier: Optional[String] = Optional.Absent,
    snapshotArn: Optional[String] = Optional.Absent,
    ownerAccount: Optional[String] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.redshift.model.NodeConfigurationOptionsFilter]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest = {
    import DescribeNodeConfigurationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest
      .builder()
      .actionType(actionType.unwrap)
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(snapshotArn.map(value => value: java.lang.String))(
        _.snapshotArn
      )
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest
      .wrap(buildAwsValue())
}
object DescribeNodeConfigurationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest =
      zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest(
        actionType,
        clusterIdentifier.map(value => value),
        snapshotIdentifier.map(value => value),
        snapshotArn.map(value => value),
        ownerAccount.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def actionType: zio.aws.redshift.model.ActionType
    def clusterIdentifier: Optional[String]
    def snapshotIdentifier: Optional[String]
    def snapshotArn: Optional[String]
    def ownerAccount: Optional[String]
    def filters: Optional[
      List[zio.aws.redshift.model.NodeConfigurationOptionsFilter.ReadOnly]
    ]
    def marker: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def getActionType: ZIO[Any, Nothing, zio.aws.redshift.model.ActionType] =
      ZIO.succeed(actionType)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotArn", snapshotArn)
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.NodeConfigurationOptionsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest
  ) extends zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest.ReadOnly {
    override val actionType: zio.aws.redshift.model.ActionType =
      zio.aws.redshift.model.ActionType.wrap(impl.actionType())
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val snapshotIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotIdentifier())
      .map(value => value: String)
    override val snapshotArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotArn())
      .map(value => value: String)
    override val ownerAccount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => value: String)
    override val filters: Optional[
      List[zio.aws.redshift.model.NodeConfigurationOptionsFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.NodeConfigurationOptionsFilter.wrap(item)
        }.toList
      )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest
  ): zio.aws.redshift.model.DescribeNodeConfigurationOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
