package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateClusterSecurityGroupResponse(
    clusterSecurityGroup: Optional[
      zio.aws.redshift.model.ClusterSecurityGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse = {
    import CreateClusterSecurityGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse
      .builder()
      .optionallyWith(clusterSecurityGroup.map(value => value.buildAwsValue()))(
        _.clusterSecurityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly =
    zio.aws.redshift.model.CreateClusterSecurityGroupResponse
      .wrap(buildAwsValue())
}
object CreateClusterSecurityGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterSecurityGroupResponse =
      zio.aws.redshift.model.CreateClusterSecurityGroupResponse(
        clusterSecurityGroup.map(value => value.asEditable)
      )
    def clusterSecurityGroup
        : Optional[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly]
    def getClusterSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("clusterSecurityGroup", clusterSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse
  ) extends zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly {
    override val clusterSecurityGroup
        : Optional[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSecurityGroup())
        .map(value => zio.aws.redshift.model.ClusterSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse
  ): zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly =
    new Wrapper(impl)
}
