package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyClusterSnapshotScheduleRequest(
    clusterIdentifier: String,
    scheduleIdentifier: Optional[String] = Optional.Absent,
    disassociateSchedule: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest = {
    import ModifyClusterSnapshotScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(scheduleIdentifier.map(value => value: java.lang.String))(
        _.scheduleIdentifier
      )
      .optionallyWith(
        disassociateSchedule.map(value => value: java.lang.Boolean)
      )(_.disassociateSchedule)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest
      .wrap(buildAwsValue())
}
object ModifyClusterSnapshotScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest =
      zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest(
        clusterIdentifier,
        scheduleIdentifier.map(value => value),
        disassociateSchedule.map(value => value)
      )
    def clusterIdentifier: String
    def scheduleIdentifier: Optional[String]
    def disassociateSchedule: Optional[BooleanOptional]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleIdentifier", scheduleIdentifier)
    def getDisassociateSchedule: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("disassociateSchedule", disassociateSchedule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest
  ) extends zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val scheduleIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleIdentifier())
      .map(value => value: String)
    override val disassociateSchedule: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disassociateSchedule())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest
  ): zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
