package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{IntegerOptional, BooleanOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateSnapshotScheduleRequest(
    scheduleDefinitions: Optional[Iterable[String]] = Optional.Absent,
    scheduleIdentifier: Optional[String] = Optional.Absent,
    scheduleDescription: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent,
    dryRun: Optional[BooleanOptional] = Optional.Absent,
    nextInvocations: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest = {
    import CreateSnapshotScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest
      .builder()
      .optionallyWith(
        scheduleDefinitions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.scheduleDefinitions)
      .optionallyWith(scheduleIdentifier.map(value => value: java.lang.String))(
        _.scheduleIdentifier
      )
      .optionallyWith(
        scheduleDescription.map(value => value: java.lang.String)
      )(_.scheduleDescription)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(nextInvocations.map(value => value: Integer))(
        _.nextInvocations
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateSnapshotScheduleRequest.ReadOnly =
    zio.aws.redshift.model.CreateSnapshotScheduleRequest.wrap(buildAwsValue())
}
object CreateSnapshotScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateSnapshotScheduleRequest =
      zio.aws.redshift.model.CreateSnapshotScheduleRequest(
        scheduleDefinitions.map(value => value),
        scheduleIdentifier.map(value => value),
        scheduleDescription.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value),
        nextInvocations.map(value => value)
      )
    def scheduleDefinitions: Optional[List[String]]
    def scheduleIdentifier: Optional[String]
    def scheduleDescription: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def dryRun: Optional[BooleanOptional]
    def nextInvocations: Optional[IntegerOptional]
    def getScheduleDefinitions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("scheduleDefinitions", scheduleDefinitions)
    def getScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleIdentifier", scheduleIdentifier)
    def getScheduleDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleDescription", scheduleDescription)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDryRun: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getNextInvocations: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("nextInvocations", nextInvocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest
  ) extends zio.aws.redshift.model.CreateSnapshotScheduleRequest.ReadOnly {
    override val scheduleDefinitions: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleDefinitions())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val scheduleIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleIdentifier())
      .map(value => value: String)
    override val scheduleDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleDescription())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
    override val dryRun: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: BooleanOptional)
    override val nextInvocations: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextInvocations())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest
  ): zio.aws.redshift.model.CreateSnapshotScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
