package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EnableLoggingRequest(
    clusterIdentifier: String,
    bucketName: Optional[String] = Optional.Absent,
    s3KeyPrefix: Optional[String] = Optional.Absent,
    logDestinationType: Optional[zio.aws.redshift.model.LogDestinationType] =
      Optional.Absent,
    logExports: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EnableLoggingRequest = {
    import EnableLoggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EnableLoggingRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(s3KeyPrefix.map(value => value: java.lang.String))(
        _.s3KeyPrefix
      )
      .optionallyWith(logDestinationType.map(value => value.unwrap))(
        _.logDestinationType
      )
      .optionallyWith(
        logExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logExports)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EnableLoggingRequest.ReadOnly =
    zio.aws.redshift.model.EnableLoggingRequest.wrap(buildAwsValue())
}
object EnableLoggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EnableLoggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EnableLoggingRequest =
      zio.aws.redshift.model.EnableLoggingRequest(
        clusterIdentifier,
        bucketName.map(value => value),
        s3KeyPrefix.map(value => value),
        logDestinationType.map(value => value),
        logExports.map(value => value)
      )
    def clusterIdentifier: String
    def bucketName: Optional[String]
    def s3KeyPrefix: Optional[String]
    def logDestinationType: Optional[zio.aws.redshift.model.LogDestinationType]
    def logExports: Optional[List[String]]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getLogDestinationType
        : ZIO[Any, AwsError, zio.aws.redshift.model.LogDestinationType] =
      AwsError.unwrapOptionField("logDestinationType", logDestinationType)
    def getLogExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logExports", logExports)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EnableLoggingRequest
  ) extends zio.aws.redshift.model.EnableLoggingRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val bucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: String)
    override val s3KeyPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value => value: String)
    override val logDestinationType
        : Optional[zio.aws.redshift.model.LogDestinationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logDestinationType())
        .map(value => zio.aws.redshift.model.LogDestinationType.wrap(value))
    override val logExports: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.logExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EnableLoggingRequest
  ): zio.aws.redshift.model.EnableLoggingRequest.ReadOnly = new Wrapper(impl)
}
